/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.storage.state.rocksdb;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.ignite.internal.rocksdb.ColumnFamily;
import org.apache.ignite.internal.rocksdb.RocksUtils;
import org.apache.ignite.internal.storage.lease.LeaseInfo;
import org.apache.ignite.internal.storage.lease.LeaseInfoSerializer;
import org.apache.ignite.internal.tx.storage.state.rocksdb.TxStateRocksDbSharedStorage;
import org.apache.ignite.internal.versioned.VersionedSerialization;
import org.apache.ignite.internal.versioned.VersionedSerializer;
import org.jetbrains.annotations.Nullable;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.RocksDBException;
import org.rocksdb.WriteBatch;

class TxStateMetaRocksDbPartitionStorage {
    static final int ZONE_PREFIX_SIZE_BYTES = 5;
    private static final int KEY_SIZE_BYTES = 7;
    static final byte LAST_APPLIED_PREFIX = 0;
    private static final byte CONF_PREFIX = 1;
    private static final byte LEASE_INFO_PREFIX = 2;
    private static final byte SNAPSHOT_INFO_PREFIX = 3;
    private final ColumnFamily columnFamily;
    private final int zoneId;
    private final int partitionId;
    private final byte[] lastAppliedKey;
    private final byte[] confKey;
    private final byte[] leaseInfoKey;
    private final byte[] snapshotInfoKey;
    private volatile long lastAppliedIndex;
    private volatile long lastAppliedTerm;
    private volatile byte @Nullable [] config;
    @Nullable
    private volatile LeaseInfo leaseInfo;

    TxStateMetaRocksDbPartitionStorage(ColumnFamily columnFamily, int zoneId, int partitionId) {
        this.columnFamily = columnFamily;
        this.partitionId = partitionId;
        this.zoneId = zoneId;
        this.lastAppliedKey = this.createKey((byte)0);
        this.confKey = this.createKey((byte)1);
        this.leaseInfoKey = this.createKey((byte)2);
        this.snapshotInfoKey = this.createKey((byte)3);
    }

    private byte[] createKey(byte prefix) {
        return ByteBuffer.allocate(7).order(TxStateRocksDbSharedStorage.BYTE_ORDER).put(prefix).putInt(this.zoneId).putShort((short)this.partitionId).array();
    }

    private static byte[] createKeyPrefixForZone(byte prefix, int zoneId) {
        return ByteBuffer.allocate(5).order(TxStateRocksDbSharedStorage.BYTE_ORDER).put(prefix).putInt(zoneId).array();
    }

    void start() throws RocksDBException {
        byte[] lastAppliedBytes = this.columnFamily.get(this.lastAppliedKey);
        if (lastAppliedBytes != null) {
            ByteBuffer buf = ByteBuffer.wrap(lastAppliedBytes).order(TxStateRocksDbSharedStorage.BYTE_ORDER);
            this.lastAppliedIndex = buf.getLong();
            this.lastAppliedTerm = buf.getLong();
        }
        this.config = this.columnFamily.get(this.confKey);
        byte[] leaseBytes = this.columnFamily.get(this.leaseInfoKey);
        if (leaseBytes != null) {
            this.leaseInfo = (LeaseInfo)VersionedSerialization.fromBytes((byte[])leaseBytes, (VersionedSerializer)LeaseInfoSerializer.INSTANCE);
        }
    }

    long lastAppliedIndex() {
        return this.lastAppliedIndex;
    }

    long lastAppliedTerm() {
        return this.lastAppliedTerm;
    }

    byte @Nullable [] configuration() {
        return this.config;
    }

    @Nullable
    LeaseInfo leaseInfo() {
        return this.leaseInfo;
    }

    byte @Nullable [] snapshotInfo() throws RocksDBException {
        return this.columnFamily.get(this.snapshotInfoKey);
    }

    void updateLastApplied(WriteBatch writeBatch, long index, long term) throws RocksDBException {
        this.columnFamily.put(writeBatch, this.lastAppliedKey, TxStateMetaRocksDbPartitionStorage.indexAndTermToBytes(index, term));
        this.lastAppliedIndex = index;
        this.lastAppliedTerm = term;
    }

    void updateConfiguration(WriteBatch writeBatch, byte[] config) throws RocksDBException {
        this.columnFamily.put(writeBatch, this.confKey, config);
        this.config = config;
    }

    void updateLease(WriteBatch writeBatch, LeaseInfo leaseInfo) throws RocksDBException {
        this.columnFamily.put(writeBatch, this.leaseInfoKey, VersionedSerialization.toBytes((Object)leaseInfo, (VersionedSerializer)LeaseInfoSerializer.INSTANCE));
        this.leaseInfo = leaseInfo;
    }

    void updateSnapshotInfo(WriteBatch writeBatch, byte[] snapshotInfo) throws RocksDBException {
        this.columnFamily.put(writeBatch, this.snapshotInfoKey, snapshotInfo);
    }

    private static byte[] indexAndTermToBytes(long lastAppliedIndex, long lastAppliedTerm) {
        return ByteBuffer.allocate(16).order(TxStateRocksDbSharedStorage.BYTE_ORDER).putLong(lastAppliedIndex).putLong(lastAppliedTerm).array();
    }

    void clear(WriteBatch writeBatch) throws RocksDBException {
        this.columnFamily.delete(writeBatch, this.lastAppliedKey);
        this.columnFamily.delete(writeBatch, this.confKey);
        this.columnFamily.delete(writeBatch, this.leaseInfoKey);
        this.columnFamily.delete(writeBatch, this.snapshotInfoKey);
        this.lastAppliedIndex = 0L;
        this.lastAppliedTerm = 0L;
        this.config = null;
        this.leaseInfo = null;
    }

    static void clearForZone(WriteBatch writeBatch, ColumnFamilyHandle cf, int zoneId) throws RocksDBException {
        for (byte prefixByte : List.of(Byte.valueOf((byte)0), Byte.valueOf((byte)1), Byte.valueOf((byte)2), Byte.valueOf((byte)3))) {
            byte[] start = TxStateMetaRocksDbPartitionStorage.createKeyPrefixForZone(prefixByte, zoneId);
            byte[] end = RocksUtils.incrementPrefix((byte[])start);
            writeBatch.deleteRange(cf, start, end);
        }
    }
}

