/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.message;

import java.util.UUID;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.internal.replicator.message.ZonePartitionIdMessage;
import org.apache.ignite.internal.tx.TxState;
import org.apache.ignite.internal.tx.message.TxMessagesFactory;
import org.apache.ignite.internal.tx.message.TxMessagesTypeInfos;
import org.apache.ignite.internal.tx.message.TxStateMetaFinishingMessage;
import org.apache.ignite.internal.tx.message.TxStateMetaFinishingMessageBuilder;

class TxStateMetaFinishingMessageDeserializer
implements MessageDeserializer<TxStateMetaFinishingMessage> {
    private final TxStateMetaFinishingMessageBuilder msg;

    TxStateMetaFinishingMessageDeserializer(TxMessagesFactory messageFactory) {
        this.msg = messageFactory.txStateMetaFinishingMessage();
    }

    public Class<TxStateMetaFinishingMessage> klass() {
        return TxStateMetaFinishingMessage.class;
    }

    public TxStateMetaFinishingMessage getMessage() {
        return this.msg.buildDeserialized();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(TxMessagesTypeInfos.txStateMetaFinishingMessage());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                Comparable<Long> tmp = reader.readBoxedLong("cleanupCompletionTimestamp");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.cleanupCompletionTimestamp((Long)tmp);
                }
                reader.incrementState();
            }
            case 1: {
                Comparable<Long> tmp = (ZonePartitionIdMessage)reader.readMessage("commitPartitionId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.commitPartitionId((ZonePartitionIdMessage)tmp);
                }
                reader.incrementState();
            }
            case 2: {
                Comparable<Long> tmp = reader.readHybridTimestamp("commitTimestamp");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.commitTimestamp((HybridTimestamp)tmp);
                }
                reader.incrementState();
            }
            case 3: {
                Comparable<Long> tmp = reader.readBoxedLong("initialVacuumObservationTimestamp");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.initialVacuumObservationTimestamp((Long)tmp);
                }
                reader.incrementState();
            }
            case 4: {
                Comparable<Long> tmp = reader.readBoxedBoolean("isFinishedDueToTimeout");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.isFinishedDueToTimeout((Boolean)tmp);
                }
                reader.incrementState();
            }
            case 5: {
                Comparable<Long> tmp = reader.readUuid("txCoordinatorId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.txCoordinatorId((UUID)tmp);
                }
                reader.incrementState();
            }
            case 6: {
                TxState tmp;
                int shiftedId = reader.readInt("txState");
                if (!reader.isLastRead()) {
                    return false;
                }
                TxState txState = tmp = shiftedId == 0 ? null : TxState.fromId(shiftedId - 1);
                if (tmp != null) {
                    this.msg.txState(tmp);
                }
                reader.incrementState();
            }
            case 7: {
                String tmp = reader.readString("txLabel");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.txLabel(tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(TxStateMetaFinishingMessage.class);
    }
}

