/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.impl;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.internal.hlc.ClockService;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.ClusterNodeResolver;
import org.apache.ignite.internal.network.InternalClusterNode;
import org.apache.ignite.internal.network.MessagingService;
import org.apache.ignite.internal.network.NetworkMessage;
import org.apache.ignite.internal.network.RecipientLeftException;
import org.apache.ignite.internal.placementdriver.PlacementDriver;
import org.apache.ignite.internal.replicator.ZonePartitionId;
import org.apache.ignite.internal.replicator.exception.PrimaryReplicaMissException;
import org.apache.ignite.internal.replicator.message.ReplicaMessagesFactory;
import org.apache.ignite.internal.tx.InternalTransaction;
import org.apache.ignite.internal.tx.TransactionMeta;
import org.apache.ignite.internal.tx.TxManager;
import org.apache.ignite.internal.tx.TxState;
import org.apache.ignite.internal.tx.TxStateMeta;
import org.apache.ignite.internal.tx.TxStateMetaFinishing;
import org.apache.ignite.internal.tx.impl.PlacementDriverHelper;
import org.apache.ignite.internal.tx.impl.TxMessageSender;
import org.apache.ignite.internal.tx.message.TransactionMetaMessage;
import org.apache.ignite.internal.tx.message.TxMessageGroup;
import org.apache.ignite.internal.tx.message.TxMessagesFactory;
import org.apache.ignite.internal.tx.message.TxStateCoordinatorRequest;
import org.apache.ignite.internal.tx.message.TxStateResponse;
import org.jetbrains.annotations.Nullable;

public class TransactionStateResolver {
    private static final TxMessagesFactory TX_MESSAGES_FACTORY = new TxMessagesFactory();
    private static final ReplicaMessagesFactory REPLICA_MESSAGES_FACTORY = new ReplicaMessagesFactory();
    private final ClusterNodeResolver clusterNodeResolver;
    private final PlacementDriverHelper placementDriverHelper;
    private final Map<UUID, CompletableFuture<TransactionMeta>> txStateFutures = new ConcurrentHashMap<UUID, CompletableFuture<TransactionMeta>>();
    private final TxManager txManager;
    private final ClockService clockService;
    private final MessagingService messagingService;
    private final TxMessageSender txMessageSender;

    public TransactionStateResolver(TxManager txManager, ClockService clockService, ClusterNodeResolver clusterNodeResolver, MessagingService messagingService, PlacementDriver placementDriver, TxMessageSender txMessageSender) {
        this.txManager = txManager;
        this.clockService = clockService;
        this.clusterNodeResolver = clusterNodeResolver;
        this.messagingService = messagingService;
        this.placementDriverHelper = new PlacementDriverHelper(placementDriver, clockService);
        this.txMessageSender = txMessageSender;
    }

    public void start() {
        this.messagingService.addMessageHandler(TxMessageGroup.class, (msg, sender, correlationId) -> {
            if (msg instanceof TxStateCoordinatorRequest) {
                TxStateCoordinatorRequest req = (TxStateCoordinatorRequest)msg;
                this.processTxStateRequest(req).thenAccept(txStateMeta -> {
                    TxStateResponse response = TX_MESSAGES_FACTORY.txStateResponse().txStateMeta(TransactionStateResolver.toTransactionMetaMessage(txStateMeta)).timestamp(this.clockService.now()).build();
                    this.messagingService.respond(sender, (NetworkMessage)response, correlationId.longValue());
                });
            }
        });
    }

    public CompletableFuture<TransactionMeta> resolveTxState(UUID txId, ZonePartitionId commitGrpId, @Nullable HybridTimestamp timestamp, @Nullable Long senderCurrentConsistencyToken, @Nullable ZonePartitionId senderGroupId) {
        return this.resolveTxState(txId, commitGrpId, timestamp, 10L, TimeUnit.SECONDS, senderCurrentConsistencyToken, senderGroupId);
    }

    public CompletableFuture<TransactionMeta> resolveTxState(UUID txId, ZonePartitionId commitGrpId, @Nullable HybridTimestamp timestamp, long awaitCommitPartitionAvailabilityTimeout, TimeUnit awaitCommitPartitionAvailabilityTimeUnit, @Nullable Long senderCurrentConsistencyToken, @Nullable ZonePartitionId senderGroupId) {
        TxStateMeta localMeta = this.txManager.stateMeta(txId);
        if (localMeta != null && TxState.isFinalState(localMeta.txState())) {
            return CompletableFuture.completedFuture(localMeta);
        }
        CompletableFuture future = this.txStateFutures.compute(txId, (k, v) -> {
            if (v == null) {
                v = new CompletableFuture<TransactionMeta>();
                this.resolveDistributiveTxState(txId, localMeta, commitGrpId, timestamp, awaitCommitPartitionAvailabilityTimeout, awaitCommitPartitionAvailabilityTimeUnit, senderCurrentConsistencyToken, senderGroupId, (CompletableFuture<TransactionMeta>)v);
            }
            return v;
        });
        future.whenComplete((v, e) -> this.txStateFutures.remove(txId));
        return future;
    }

    private void resolveDistributiveTxState(UUID txId, @Nullable TxStateMeta localMeta, ZonePartitionId commitGrpId, @Nullable HybridTimestamp timestamp, long awaitCommitPartitionAvailabilityTimeout, TimeUnit awaitCommitPartitionAvailabilityTimeUnit, @Nullable Long senderCurrentConsistencyToken, @Nullable ZonePartitionId senderGroupId, CompletableFuture<TransactionMeta> txMetaFuture) {
        HybridTimestamp timestamp0;
        assert (localMeta == null || !TxState.isFinalState(localMeta.txState())) : "Unexpected tx meta [txId" + txId + ", meta=" + localMeta + "]";
        HybridTimestamp hybridTimestamp = timestamp0 = timestamp == null ? HybridTimestamp.MIN_VALUE : timestamp;
        if (localMeta == null) {
            this.resolveTxStateFromCommitPartition(txId, commitGrpId, awaitCommitPartitionAvailabilityTimeout, awaitCommitPartitionAvailabilityTimeUnit, txMetaFuture, senderCurrentConsistencyToken, senderGroupId);
        } else if (localMeta.txState() == TxState.PENDING) {
            this.resolveTxStateFromTxCoordinator(txId, localMeta.txCoordinatorId(), commitGrpId, timestamp0, senderCurrentConsistencyToken, senderGroupId, txMetaFuture);
        } else if (localMeta.txState() == TxState.FINISHING) {
            assert (localMeta instanceof TxStateMetaFinishing);
            ((TxStateMetaFinishing)localMeta).txFinishFuture().whenComplete((v, e) -> {
                if (e == null) {
                    txMetaFuture.complete((TransactionMeta)v);
                } else {
                    txMetaFuture.completeExceptionally((Throwable)e);
                }
            });
        } else {
            assert (localMeta.txState() == TxState.ABANDONED) : "Unexpected transaction state [txId=" + txId + ", txStateMeta=" + localMeta + "]";
            this.resolveTxStateFromCommitPartition(txId, commitGrpId, senderCurrentConsistencyToken, senderGroupId, txMetaFuture);
        }
    }

    private void resolveTxStateFromTxCoordinator(UUID txId, @Nullable UUID coordinatorId, ZonePartitionId commitGrpId, HybridTimestamp timestamp, @Nullable Long senderCurrentConsistencyToken, @Nullable ZonePartitionId senderGroupId, CompletableFuture<TransactionMeta> txMetaFuture) {
        InternalClusterNode coordinator;
        this.updateLocalTxMapAfterDistributedStateResolved(txId, txMetaFuture);
        InternalClusterNode internalClusterNode = coordinator = coordinatorId == null ? null : this.clusterNodeResolver.getById(coordinatorId);
        if (coordinator == null) {
            this.markAbandoned(txId);
            this.resolveTxStateFromCommitPartition(txId, commitGrpId, senderCurrentConsistencyToken, senderGroupId, txMetaFuture);
        } else {
            this.txMessageSender.resolveTxStateFromCoordinator(coordinator, txId, timestamp, senderCurrentConsistencyToken, senderGroupId).whenComplete((response, e) -> {
                if (e == null && response.txStateMeta() != null) {
                    txMetaFuture.complete(response.txStateMeta().asTransactionMeta());
                } else {
                    if (e != null && e.getCause() instanceof RecipientLeftException) {
                        this.markAbandoned(txId);
                    }
                    this.resolveTxStateFromCommitPartition(txId, commitGrpId, senderCurrentConsistencyToken, senderGroupId, txMetaFuture);
                }
            });
        }
    }

    private void resolveTxStateFromCommitPartition(UUID txId, ZonePartitionId commitGrpId, @Nullable Long senderCurrentConsistencyToken, @Nullable ZonePartitionId senderGroupId, CompletableFuture<TransactionMeta> txMetaFuture) {
        this.resolveTxStateFromCommitPartition(txId, commitGrpId, 10L, TimeUnit.SECONDS, txMetaFuture, senderCurrentConsistencyToken, senderGroupId);
    }

    private void resolveTxStateFromCommitPartition(UUID txId, ZonePartitionId commitGrpId, long awaitPrimaryReplicaTimeout, TimeUnit awaitPrimaryReplicaTimeUnit, CompletableFuture<TransactionMeta> txMetaFuture, @Nullable Long senderCurrentConsistencyToken, @Nullable ZonePartitionId senderGroupId) {
        this.updateLocalTxMapAfterDistributedStateResolved(txId, txMetaFuture);
        this.sendAndRetry(txMetaFuture, commitGrpId, txId, awaitPrimaryReplicaTimeout, awaitPrimaryReplicaTimeUnit, senderCurrentConsistencyToken, senderGroupId);
    }

    private void markAbandoned(UUID txId) {
        this.txManager.updateTxMeta(txId, stateMeta -> stateMeta != null ? stateMeta.abandoned() : null);
    }

    private void updateLocalTxMapAfterDistributedStateResolved(UUID txId, CompletableFuture<TransactionMeta> future) {
        future.thenAccept(txMeta -> {
            if (txMeta instanceof TxStateMeta) {
                this.txManager.updateTxMeta(txId, old -> (TxStateMeta)txMeta);
            }
        });
    }

    private void sendAndRetry(CompletableFuture<TransactionMeta> resFut, ZonePartitionId replicaGrp, UUID txId, long awaitPrimaryReplicaTimeout, TimeUnit awaitPrimaryReplicaTimeUnit, @Nullable Long senderCurrentConsistencyToken, @Nullable ZonePartitionId senderGroupId) {
        ((CompletableFuture)this.placementDriverHelper.awaitPrimaryReplicaWithExceptionHandling(replicaGrp, awaitPrimaryReplicaTimeout, awaitPrimaryReplicaTimeUnit).thenCompose(replicaMeta -> this.txMessageSender.resolveTxStateFromCommitPartition(replicaMeta.getLeaseholder(), txId, replicaGrp, replicaMeta.getStartTime().longValue(), senderCurrentConsistencyToken, senderGroupId))).whenComplete((txMeta, e) -> {
            if (e == null) {
                assert (txMeta != null) : "Tx State response is null";
                resFut.complete((TransactionMeta)txMeta);
            } else if (e instanceof PrimaryReplicaMissException) {
                this.sendAndRetry(resFut, replicaGrp, txId, awaitPrimaryReplicaTimeout, awaitPrimaryReplicaTimeUnit, senderCurrentConsistencyToken, senderGroupId);
            } else {
                resFut.completeExceptionally((Throwable)e);
            }
        });
    }

    private CompletableFuture<@Nullable TransactionMeta> processTxStateRequest(TxStateCoordinatorRequest request) {
        this.clockService.updateClock(request.readTimestamp());
        UUID txId = request.txId();
        TxStateMeta txStateMeta = this.txManager.stateMeta(txId);
        if (txStateMeta != null) {
            ZonePartitionId groupId;
            if (TxState.isFinalState(txStateMeta.txState())) {
                return CompletableFuture.completedFuture(txStateMeta);
            }
            if (txStateMeta.txState() == TxState.FINISHING) {
                assert (txStateMeta instanceof TxStateMetaFinishing);
                TxStateMetaFinishing txStateMetaFinishing = (TxStateMetaFinishing)txStateMeta;
                return txStateMetaFinishing.txFinishFuture();
            }
            InternalTransaction tx = txStateMeta.tx();
            Long currentConsistencyToken = request.senderCurrentConsistencyToken();
            ZonePartitionId zonePartitionId = groupId = request.senderGroupId() == null ? null : request.senderGroupId().asZonePartitionId();
            if (tx != null && !tx.isReadOnly() && currentConsistencyToken != null && groupId != null) {
                return this.txManager.checkEnlistedPartitionsAndAbortIfNeeded(txStateMeta, tx, currentConsistencyToken, groupId);
            }
        }
        return CompletableFuture.completedFuture(txStateMeta);
    }

    @Nullable
    private static TransactionMetaMessage toTransactionMetaMessage(@Nullable TransactionMeta transactionMeta) {
        return transactionMeta == null ? null : transactionMeta.toTransactionMetaMessage(REPLICA_MESSAGES_FACTORY, TX_MESSAGES_FACTORY);
    }
}

