/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.impl;

import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite.internal.hlc.ClockService;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.placementdriver.PlacementDriver;
import org.apache.ignite.internal.placementdriver.ReplicaMeta;
import org.apache.ignite.internal.replicator.ReplicationGroupId;
import org.apache.ignite.internal.replicator.ZonePartitionId;
import org.apache.ignite.internal.tx.MismatchingTransactionOutcomeInternalException;
import org.apache.ignite.internal.tx.PendingTxPartitionEnlistment;
import org.apache.ignite.internal.tx.TransactionResult;
import org.apache.ignite.internal.tx.TxState;
import org.apache.ignite.internal.tx.impl.PrimaryReplicaExpiredException;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.lang.ErrorGroups;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class TransactionInflights {
    private static final int MAX_CONCURRENT_TXNS = 1024;
    private final ConcurrentHashMap<UUID, TxContext> txCtxMap = new ConcurrentHashMap(1024);
    private final PlacementDriver placementDriver;
    private final ClockService clockService;

    public TransactionInflights(PlacementDriver placementDriver, ClockService clockService) {
        this.placementDriver = placementDriver;
        this.clockService = clockService;
    }

    public boolean addInflight(UUID txId) {
        boolean[] res = new boolean[]{true};
        this.txCtxMap.compute(txId, (uuid, ctx) -> {
            if (ctx == null) {
                ctx = new ReadWriteTxContext(this.placementDriver, this.clockService);
            }
            res[0] = ctx.addInflight();
            return ctx;
        });
        return res[0];
    }

    public boolean addScanInflight(UUID txId) {
        boolean[] res = new boolean[]{true};
        this.txCtxMap.compute(txId, (uuid, ctx) -> {
            if (ctx == null) {
                ctx = new ReadOnlyTxContext();
            }
            res[0] = ctx.addInflight();
            return ctx;
        });
        return res[0];
    }

    public boolean track(UUID txId) {
        boolean[] res = new boolean[]{true};
        this.txCtxMap.compute(txId, (uuid, ctx) -> {
            if (ctx == null) {
                ctx = new ReadWriteTxContext(this.placementDriver, this.clockService);
            }
            res[0] = !ctx.isTxFinishing();
            return ctx;
        });
        return res[0];
    }

    public boolean trackReadOnly(UUID txId) {
        boolean[] res = new boolean[]{true};
        this.txCtxMap.compute(txId, (uuid, ctx) -> {
            if (ctx == null) {
                ctx = new ReadOnlyTxContext();
            }
            res[0] = !ctx.isTxFinishing();
            return ctx;
        });
        return res[0];
    }

    public void removeInflight(UUID txId) {
        TxContext tuple = this.txCtxMap.computeIfPresent(txId, (uuid, ctx) -> {
            ctx.removeInflight(txId);
            return ctx;
        });
        if (tuple != null) {
            tuple.onInflightRemoved(tuple.err);
        }
    }

    void removeInflight(UUID txId, Throwable cause) {
        TxContext tuple = this.txCtxMap.computeIfPresent(txId, (uuid, ctx) -> {
            if (cause != null && ctx.err == null) {
                ctx.err = cause;
            }
            ctx.removeInflight(txId);
            return ctx;
        });
        if (tuple != null) {
            tuple.onInflightRemoved(tuple.err);
        }
    }

    @TestOnly
    public boolean hasActiveInflights() {
        for (TxContext value : this.txCtxMap.values()) {
            if (value.isTxFinishing()) continue;
            return true;
        }
        return false;
    }

    Collection<UUID> finishedReadOnlyTransactions() {
        return this.txCtxMap.entrySet().stream().filter(e -> e.getValue() instanceof ReadOnlyTxContext && ((TxContext)e.getValue()).isReadyToFinish()).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    void removeTxContext(UUID txId) {
        this.txCtxMap.remove(txId);
    }

    void removeTxContexts(Collection<UUID> txIds) {
        ((ConcurrentHashMap.KeySetView)this.txCtxMap.keySet()).removeAll((Collection)txIds);
    }

    void cancelWaitingInflights(ZonePartitionId groupId) {
        for (Map.Entry<UUID, TxContext> ctxEntry : this.txCtxMap.entrySet()) {
            PendingTxPartitionEnlistment enlistment;
            ReadWriteTxContext txContext;
            if (!(ctxEntry.getValue() instanceof ReadWriteTxContext) || !(txContext = (ReadWriteTxContext)ctxEntry.getValue()).isTxFinishing() || (enlistment = txContext.enlistedGroups.get(groupId)) == null) continue;
            txContext.cancelWaitingInflights(groupId, enlistment.consistencyToken());
        }
    }

    void markReadOnlyTxFinished(UUID txId) {
        this.txCtxMap.compute(txId, (k, ctx) -> {
            if (ctx == null) {
                ctx = new ReadOnlyTxContext();
            } else assert (ctx instanceof ReadOnlyTxContext);
            ctx.finishTx(null);
            return ctx;
        });
    }

    ReadWriteTxContext lockTxForNewUpdates(UUID txId, Map<ZonePartitionId, PendingTxPartitionEnlistment> enlistedGroups) {
        return (ReadWriteTxContext)this.txCtxMap.compute(txId, (uuid, tuple0) -> {
            if (tuple0 == null) {
                tuple0 = new ReadWriteTxContext(this.placementDriver, this.clockService, true);
            }
            assert (!tuple0.isTxFinishing()) : "Transaction is already finished [id=" + uuid + "].";
            tuple0.finishTx(enlistedGroups);
            return tuple0;
        });
    }

    static abstract class TxContext {
        volatile long inflights = 0L;
        Throwable err;

        TxContext() {
        }

        boolean addInflight() {
            if (this.isTxFinishing()) {
                return false;
            }
            ++this.inflights;
            return true;
        }

        void removeInflight(UUID txId) {
            assert (this.inflights > 0L) : IgniteStringFormatter.format((String)"No inflights, cannot remove any [txId={}, ctx={}]", (Object[])new Object[]{txId, this});
            --this.inflights;
        }

        abstract void onInflightRemoved(@Nullable Throwable var1);

        abstract void finishTx(@Nullable Map<ZonePartitionId, PendingTxPartitionEnlistment> var1);

        abstract boolean isTxFinishing();

        abstract boolean isReadyToFinish();
    }

    static class ReadWriteTxContext
    extends TxContext {
        private final CompletableFuture<Void> waitRepFut = new CompletableFuture();
        private final PlacementDriver placementDriver;
        private final boolean noWrites;
        private volatile CompletableFuture<Void> finishInProgressFuture = null;
        private volatile Map<ZonePartitionId, PendingTxPartitionEnlistment> enlistedGroups;
        private final ClockService clockService;

        private ReadWriteTxContext(PlacementDriver placementDriver, ClockService clockService) {
            this(placementDriver, clockService, false);
        }

        private ReadWriteTxContext(PlacementDriver placementDriver, ClockService clockService, boolean noWrites) {
            this.placementDriver = placementDriver;
            this.clockService = clockService;
            this.noWrites = noWrites;
        }

        CompletableFuture<Void> performFinish(boolean commit, Function<Boolean, CompletableFuture<Void>> finishAction) {
            this.waitReadyToFinish(commit).whenComplete((ignored, readyException) -> {
                try {
                    if (commit) {
                        if (readyException == null) {
                            CompletableFuture actionFut = (CompletableFuture)finishAction.apply(true);
                            actionFut.whenComplete((ignoredFinishActionResult, finishException) -> this.completeFinishInProgressFuture(true, null, (Throwable)finishException));
                        } else {
                            this.completeFinishInProgressFuture(true, (Throwable)readyException, null);
                            finishAction.apply(false);
                        }
                        return;
                    }
                    CompletableFuture actionFut = (CompletableFuture)finishAction.apply(false);
                    actionFut.whenComplete((ignoredFinishActionResult, finishException) -> this.completeFinishInProgressFuture(false, (Throwable)readyException, (Throwable)finishException));
                }
                catch (Throwable err) {
                    this.completeFinishInProgressFuture(commit, (Throwable)readyException, err);
                }
            });
            return this.finishInProgressFuture;
        }

        private void completeFinishInProgressFuture(boolean commit, @Nullable Throwable readyToFinishException, @Nullable Throwable finishException) {
            if (readyToFinishException == null) {
                if (finishException == null) {
                    this.finishInProgressFuture.complete(null);
                } else {
                    this.finishInProgressFuture.completeExceptionally(finishException);
                }
            } else {
                Throwable unwrappedReadyToFinishException = ExceptionUtils.unwrapCause((Throwable)readyToFinishException);
                if (commit && unwrappedReadyToFinishException instanceof PrimaryReplicaExpiredException) {
                    this.finishInProgressFuture.completeExceptionally((Throwable)((Object)new MismatchingTransactionOutcomeInternalException(ErrorGroups.Transactions.TX_PRIMARY_REPLICA_EXPIRED_ERR, "Failed to commit the transaction.", new TransactionResult(TxState.ABORTED, null), unwrappedReadyToFinishException)));
                } else {
                    this.finishInProgressFuture.completeExceptionally(unwrappedReadyToFinishException);
                }
            }
        }

        private CompletableFuture<Void> waitReadyToFinish(boolean commit) {
            if (commit) {
                HybridTimestamp now = this.clockService.now();
                CompletableFuture[] futures = new CompletableFuture[this.enlistedGroups.size()];
                int cntr = 0;
                for (Map.Entry<ZonePartitionId, PendingTxPartitionEnlistment> e : this.enlistedGroups.entrySet()) {
                    futures[cntr++] = this.placementDriver.getPrimaryReplica((ReplicationGroupId)e.getKey(), now).thenApply(replicaMeta -> {
                        long enlistmentConsistencyToken = ((PendingTxPartitionEnlistment)e.getValue()).consistencyToken();
                        if (replicaMeta == null || enlistmentConsistencyToken != replicaMeta.getStartTime().longValue()) {
                            return CompletableFuture.failedFuture((Throwable)((Object)new PrimaryReplicaExpiredException((ZonePartitionId)e.getKey(), enlistmentConsistencyToken, null, (ReplicaMeta)replicaMeta)));
                        }
                        return CompletableFutures.nullCompletedFuture();
                    });
                }
                return CompletableFutures.allOfToList((CompletableFuture[])futures).thenCompose(unused -> this.waitNoInflights());
            }
            return CompletableFutures.nullCompletedFuture();
        }

        private CompletableFuture<Void> waitNoInflights() {
            if (this.inflights == 0L) {
                if (this.err != null) {
                    this.waitRepFut.completeExceptionally(this.err);
                } else {
                    this.waitRepFut.complete(null);
                }
            }
            return this.waitRepFut;
        }

        void cancelWaitingInflights(ZonePartitionId groupId, long enlistmentConsistencyToken) {
            this.waitRepFut.completeExceptionally((Throwable)((Object)new PrimaryReplicaExpiredException(groupId, enlistmentConsistencyToken, null, null)));
        }

        @Override
        void onInflightRemoved(@Nullable Throwable t) {
            if (this.inflights == 0L && this.finishInProgressFuture != null) {
                if (t == null) {
                    this.waitRepFut.complete(null);
                } else {
                    this.waitRepFut.completeExceptionally(t);
                }
            }
        }

        @Override
        public void finishTx(Map<ZonePartitionId, PendingTxPartitionEnlistment> enlistedGroups) {
            this.enlistedGroups = enlistedGroups;
            this.finishInProgressFuture = new CompletableFuture();
        }

        @Override
        public boolean isTxFinishing() {
            return this.finishInProgressFuture != null;
        }

        @Override
        public boolean isReadyToFinish() {
            return this.waitRepFut.isDone();
        }

        boolean isNoWrites() {
            return this.noWrites;
        }

        public String toString() {
            return "ReadWriteTxContext [inflights=" + this.inflights + ", waitRepFut=" + this.waitRepFut + ", noWrites=" + this.noWrites + ", finishFut=" + this.finishInProgressFuture + "]";
        }
    }

    private static class ReadOnlyTxContext
    extends TxContext {
        private volatile boolean markedFinished;

        ReadOnlyTxContext() {
        }

        @Override
        void onInflightRemoved(Throwable t) {
        }

        @Override
        public void finishTx(@Nullable Map<ZonePartitionId, PendingTxPartitionEnlistment> enlistedGroups) {
            this.markedFinished = true;
        }

        @Override
        public boolean isTxFinishing() {
            return this.markedFinished;
        }

        @Override
        public boolean isReadyToFinish() {
            return this.markedFinished && this.inflights == 0L;
        }

        public String toString() {
            return "ReadOnlyTxContext [inflights=" + this.inflights + "]";
        }
    }
}

