/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx;

import java.util.UUID;
import org.apache.ignite.internal.replicator.ZonePartitionId;
import org.apache.ignite.internal.replicator.message.ReplicaMessageUtils;
import org.apache.ignite.internal.replicator.message.ReplicaMessagesFactory;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.tx.InternalTransaction;
import org.apache.ignite.internal.tx.TxState;
import org.apache.ignite.internal.tx.TxStateMeta;
import org.apache.ignite.internal.tx.message.TxMessagesFactory;
import org.apache.ignite.internal.tx.message.TxStateMetaAbandonedMessage;
import org.apache.ignite.internal.util.FastTimestamps;
import org.jetbrains.annotations.Nullable;

public class TxStateMetaAbandoned
extends TxStateMeta {
    private static final long serialVersionUID = 8521181896862227127L;
    private final long lastAbandonedMarkerTs = FastTimestamps.coarseCurrentTimeMillis();

    public TxStateMetaAbandoned(@Nullable UUID txCoordinatorId, @Nullable ZonePartitionId commitPartitionId, @Nullable InternalTransaction tx, @Nullable String txLabel) {
        super(TxState.ABANDONED, txCoordinatorId, commitPartitionId, null, tx, null, null, null, txLabel);
    }

    public long lastAbandonedMarkerTs() {
        return this.lastAbandonedMarkerTs;
    }

    @Override
    public TxStateMetaAbandonedMessage toTransactionMetaMessage(ReplicaMessagesFactory replicaMessagesFactory, TxMessagesFactory txMessagesFactory) {
        ZonePartitionId commitPartitionId = this.commitPartitionId();
        return txMessagesFactory.txStateMetaAbandonedMessage().txState(this.txState()).txCoordinatorId(this.txCoordinatorId()).commitPartitionId(commitPartitionId == null ? null : ReplicaMessageUtils.toZonePartitionIdMessage((ReplicaMessagesFactory)replicaMessagesFactory, (ZonePartitionId)commitPartitionId)).commitTimestamp(this.commitTimestamp()).initialVacuumObservationTimestamp(this.initialVacuumObservationTimestamp()).cleanupCompletionTimestamp(this.cleanupCompletionTimestamp()).lastAbandonedMarkerTs(this.lastAbandonedMarkerTs).txLabel(this.txLabel()).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TxStateMetaAbandoned that = (TxStateMetaAbandoned)o;
        return this.lastAbandonedMarkerTs == that.lastAbandonedMarkerTs;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Long.hashCode(this.lastAbandonedMarkerTs);
        return result;
    }

    @Override
    public String toString() {
        return S.toString(TxStateMetaAbandoned.class, (Object)this);
    }

    @Override
    public TxStateMetaAbandonedBuilder mutate() {
        return new TxStateMetaAbandonedBuilder(this);
    }

    public static class TxStateMetaAbandonedBuilder
    extends TxStateMeta.TxStateMetaBuilder {
        TxStateMetaAbandonedBuilder(TxStateMeta old) {
            super(old);
        }

        @Override
        public TxStateMeta build() {
            if (this.txState == TxState.ABANDONED) {
                return new TxStateMetaAbandoned(this.txCoordinatorId, this.commitPartitionId, this.tx, this.txLabel);
            }
            return super.build();
        }
    }
}

