/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx;

import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.hlc.HybridTimestampTracker;
import org.apache.ignite.internal.manager.IgniteComponent;
import org.apache.ignite.internal.replicator.ZonePartitionId;
import org.apache.ignite.internal.tx.InternalTransaction;
import org.apache.ignite.internal.tx.InternalTxOptions;
import org.apache.ignite.internal.tx.LockManager;
import org.apache.ignite.internal.tx.PartitionEnlistment;
import org.apache.ignite.internal.tx.PendingTxPartitionEnlistment;
import org.apache.ignite.internal.tx.TransactionMeta;
import org.apache.ignite.internal.tx.TxPriority;
import org.apache.ignite.internal.tx.TxStateMeta;
import org.apache.ignite.internal.tx.impl.EnlistedPartitionGroup;
import org.apache.ignite.internal.tx.metrics.ResourceVacuumMetrics;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public interface TxManager
extends IgniteComponent {
    default public InternalTransaction beginImplicitRw(HybridTimestampTracker timestampTracker) {
        return this.beginImplicit(timestampTracker, false, null);
    }

    default public InternalTransaction beginImplicitRo(HybridTimestampTracker timestampTracker) {
        return this.beginImplicit(timestampTracker, true, null);
    }

    public InternalTransaction beginImplicit(HybridTimestampTracker var1, boolean var2, @Nullable String var3);

    default public InternalTransaction beginExplicitRw(HybridTimestampTracker timestampTracker, InternalTxOptions options) {
        return this.beginExplicit(timestampTracker, false, options);
    }

    default public InternalTransaction beginExplicitRo(HybridTimestampTracker timestampTracker, InternalTxOptions options) {
        return this.beginExplicit(timestampTracker, true, options);
    }

    public InternalTransaction beginExplicit(HybridTimestampTracker var1, boolean var2, InternalTxOptions var3);

    public InternalTransaction beginRemote(UUID var1, ZonePartitionId var2, UUID var3, long var4, long var6, boolean var8, Consumer<Throwable> var9);

    public InternalTransaction beginExternal(HybridTimestampTracker var1, boolean var2);

    public InternalTransaction beginExternal(HybridTimestampTracker var1, boolean var2, TxPriority var3);

    public InternalTransaction castToExternal(InternalTransaction var1);

    @Nullable
    public TxStateMeta stateMeta(UUID var1);

    public CompletableFuture<@Nullable TransactionMeta> checkEnlistedPartitionsAndAbortIfNeeded(TxStateMeta var1, InternalTransaction var2, long var3, ZonePartitionId var5);

    @Nullable
    public <T extends TxStateMeta> T updateTxMeta(UUID var1, Function<@Nullable TxStateMeta, TxStateMeta> var2);

    @Deprecated
    public LockManager lockManager();

    public CompletableFuture<Void> executeWriteIntentSwitchAsync(Runnable var1);

    public void finishFull(HybridTimestampTracker var1, UUID var2, @Nullable HybridTimestamp var3, boolean var4, boolean var5);

    public CompletableFuture<Void> finish(HybridTimestampTracker var1, @Nullable ZonePartitionId var2, boolean var3, boolean var4, boolean var5, boolean var6, Map<ZonePartitionId, PendingTxPartitionEnlistment> var7, UUID var8);

    public CompletableFuture<Void> cleanup(@Nullable ZonePartitionId var1, Map<ZonePartitionId, PartitionEnlistment> var2, boolean var3, @Nullable HybridTimestamp var4, UUID var5);

    public CompletableFuture<Void> cleanup(@Nullable ZonePartitionId var1, Collection<EnlistedPartitionGroup> var2, boolean var3, @Nullable HybridTimestamp var4, UUID var5);

    public CompletableFuture<Void> cleanup(ZonePartitionId var1, String var2, UUID var3);

    public CompletableFuture<Void> vacuum(ResourceVacuumMetrics var1);

    public CompletableFuture<Boolean> kill(UUID var1);

    public int lockRetryCount();

    @TestOnly
    public int finished();

    @TestOnly
    public int pending();
}

