/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.message;

import java.util.List;
import java.util.UUID;
import org.apache.ignite.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.internal.replicator.message.ZonePartitionIdMessage;
import org.apache.ignite.internal.tx.message.CleanupReplicatedInfoMessage;
import org.apache.ignite.internal.tx.message.CleanupReplicatedInfoMessageBuilder;
import org.apache.ignite.internal.tx.message.TxMessagesFactory;
import org.apache.ignite.internal.tx.message.TxMessagesTypeInfos;

class CleanupReplicatedInfoMessageDeserializer
implements MessageDeserializer<CleanupReplicatedInfoMessage> {
    private final CleanupReplicatedInfoMessageBuilder msg;

    CleanupReplicatedInfoMessageDeserializer(TxMessagesFactory messageFactory) {
        this.msg = messageFactory.cleanupReplicatedInfoMessage();
    }

    public Class<CleanupReplicatedInfoMessage> klass() {
        return CleanupReplicatedInfoMessage.class;
    }

    public CleanupReplicatedInfoMessage getMessage() {
        return this.msg.buildDeserialized();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(TxMessagesTypeInfos.cleanupReplicatedInfoMessage());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                Object tmp = reader.readList("partitions", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.partitions((List<ZonePartitionIdMessage>)tmp);
                }
                reader.incrementState();
            }
            case 1: {
                Object tmp = reader.readUuid("txId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.txId((UUID)tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(CleanupReplicatedInfoMessage.class);
    }
}

