/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.replicator.ZonePartitionId;
import org.apache.ignite.internal.replicator.message.ReplicaMessagesFactory;
import org.apache.ignite.internal.tx.TransactionMeta;
import org.apache.ignite.internal.tx.TxState;
import org.apache.ignite.internal.tx.TxStateMeta;
import org.apache.ignite.internal.tx.message.TxMessagesFactory;
import org.apache.ignite.internal.tx.message.TxStateMetaMessage;
import org.jetbrains.annotations.Nullable;

public class TxStateMetaFinishing
extends TxStateMeta {
    private static final long serialVersionUID = 9122953981654023665L;
    private final CompletableFuture<TransactionMeta> txFinishFuture = new CompletableFuture();

    public TxStateMetaFinishing(@Nullable UUID txCoordinatorId, @Nullable ZonePartitionId commitPartitionId, @Nullable Boolean isFinishingDueToTimeout, @Nullable String txLabel) {
        super(TxState.FINISHING, txCoordinatorId, commitPartitionId, null, null, null, null, isFinishingDueToTimeout, txLabel);
    }

    public CompletableFuture<TransactionMeta> txFinishFuture() {
        return this.txFinishFuture;
    }

    @Override
    @Nullable
    public HybridTimestamp commitTimestamp() {
        throw new UnsupportedOperationException("Can't get commit timestamp from FINISHING transaction state meta.");
    }

    @Override
    public TxStateMetaMessage toTransactionMetaMessage(ReplicaMessagesFactory replicaMessagesFactory, TxMessagesFactory txMessagesFactory) {
        throw new AssertionError((Object)"This state shouldn't be transferred over the network.");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TxStateMetaFinishing that = (TxStateMetaFinishing)o;
        return this.txFinishFuture.equals(that.txFinishFuture);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.txFinishFuture.hashCode();
        return result;
    }

    @Override
    public TxStateMeta.TxStateMetaBuilder mutate() {
        return new TxStateMetaFinishingBuilder(this);
    }

    public static class TxStateMetaFinishingBuilder
    extends TxStateMeta.TxStateMetaBuilder {
        TxStateMetaFinishingBuilder(TxStateMeta old) {
            super(old);
        }

        @Override
        public TxStateMeta build() {
            if (this.txState == TxState.FINISHING) {
                return new TxStateMetaFinishing(this.txCoordinatorId, this.commitPartitionId, this.isFinishedDueToTimeout, this.txLabel);
            }
            return super.build();
        }
    }
}

