/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.replicator.ZonePartitionId;
import org.apache.ignite.internal.tx.TxMeta;
import org.apache.ignite.internal.tx.TxState;
import org.apache.ignite.internal.tx.impl.EnlistedPartitionGroup;
import org.apache.ignite.internal.util.io.IgniteDataInput;
import org.apache.ignite.internal.util.io.IgniteDataOutput;
import org.apache.ignite.internal.versioned.VersionedSerializer;

public class TxMetaSerializer
extends VersionedSerializer<TxMeta> {
    public static final TxMetaSerializer INSTANCE = new TxMetaSerializer();

    protected byte getProtocolVersion() {
        return 2;
    }

    protected void writeExternalData(TxMeta meta, IgniteDataOutput out) throws IOException {
        boolean hasAnyZonePartitionIds = true;
        out.writeBoolean(hasAnyZonePartitionIds);
        out.writeVarInt((long)meta.txState().id());
        out.writeVarInt((long)meta.enlistedPartitions().size());
        for (EnlistedPartitionGroup enlistedPartitionGroup : meta.enlistedPartitions()) {
            ZonePartitionId partitionGroupId = enlistedPartitionGroup.groupId();
            out.writeVarInt((long)partitionGroupId.objectId());
            out.writeVarInt((long)partitionGroupId.partitionId());
            TxMetaSerializer.writeVarIntSet(enlistedPartitionGroup.tableIds(), (IgniteDataOutput)out);
        }
        HybridTimestamp.write((HybridTimestamp)meta.commitTimestamp(), (IgniteDataOutput)out);
    }

    protected TxMeta readExternalData(byte protoVer, IgniteDataInput in) throws IOException {
        if (protoVer == 1) {
            throw new IllegalArgumentException("Transaction meta v1 is not supported.");
        }
        if (protoVer >= 2) {
            boolean usesZonePartitionIds = in.readBoolean();
            assert (usesZonePartitionIds) : "Transaction meta cannot be deserialized. V1 is not supported anymore.";
        }
        TxState state = TxState.fromId(in.readVarIntAsInt());
        List<EnlistedPartitionGroup> enlistedPartitions = TxMetaSerializer.readEnlistedPartitions(in, protoVer);
        HybridTimestamp commitTimestamp = HybridTimestamp.readNullableFrom((IgniteDataInput)in);
        return new TxMeta(state, enlistedPartitions, commitTimestamp);
    }

    private static List<EnlistedPartitionGroup> readEnlistedPartitions(IgniteDataInput in, byte protoVer) throws IOException {
        assert (protoVer >= 2) : "Unsupported protocol version [ver=" + protoVer + "].";
        int length = in.readVarIntAsInt();
        ArrayList<EnlistedPartitionGroup> enlistedPartitions = new ArrayList<EnlistedPartitionGroup>(length);
        for (int i = 0; i < length; ++i) {
            int objectId = in.readVarIntAsInt();
            int partitionId = in.readVarIntAsInt();
            Set tableIds = TxMetaSerializer.readVarIntSet((IgniteDataInput)in);
            enlistedPartitions.add(new EnlistedPartitionGroup(new ZonePartitionId(objectId, partitionId), tableIds));
        }
        return enlistedPartitions;
    }
}

