/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx;

import com.google.auto.service.AutoService;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.ignite.internal.lang.IgniteExceptionMapper;
import org.apache.ignite.internal.lang.IgniteExceptionMappersProvider;
import org.apache.ignite.internal.replicator.exception.ReplicationException;
import org.apache.ignite.internal.tx.DelayedAckException;
import org.apache.ignite.internal.tx.IncompatibleSchemaAbortException;
import org.apache.ignite.internal.tx.LockException;
import org.apache.ignite.internal.tx.MismatchingTransactionOutcomeInternalException;
import org.apache.ignite.tx.IncompatibleSchemaException;
import org.apache.ignite.tx.MismatchingTransactionOutcomeException;
import org.apache.ignite.tx.TransactionException;

@AutoService(value={IgniteExceptionMappersProvider.class})
public class TransactionExceptionMapperProvider
implements IgniteExceptionMappersProvider {
    public Collection<IgniteExceptionMapper<?, ?>> mappers() {
        ArrayList mappers = new ArrayList();
        mappers.add(IgniteExceptionMapper.unchecked(LockException.class, err -> new TransactionException(err.traceId(), err.code(), err.getMessage(), (Throwable)((Object)err))));
        mappers.add(IgniteExceptionMapper.unchecked(ReplicationException.class, err -> new TransactionException(err.traceId(), err.code(), err.getMessage(), (Throwable)err)));
        mappers.add(IgniteExceptionMapper.unchecked(MismatchingTransactionOutcomeInternalException.class, err -> new MismatchingTransactionOutcomeException(err.traceId(), err.code(), err.getMessage(), (Throwable)((Object)err))));
        mappers.add(IgniteExceptionMapper.unchecked(IncompatibleSchemaAbortException.class, err -> new IncompatibleSchemaException(err.traceId(), err.code(), err.getMessage(), (Throwable)((Object)err))));
        mappers.add(IgniteExceptionMapper.unchecked(DelayedAckException.class, err -> new TransactionException(err.traceId(), err.code(), err.getMessage(), err.getCause())));
        return mappers;
    }
}

