/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.message;

import org.apache.ignite.internal.network.NetworkMessage;
import org.apache.ignite.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.MessageWriter;
import org.apache.ignite.internal.tx.message.TxFinishReplicaRequest;
import org.apache.ignite.internal.tx.message.TxFinishReplicaRequestImpl;
import org.apache.ignite.internal.tx.message.TxMessagesTypeInfos;

class TxFinishReplicaRequestSerializer
implements MessageSerializer<TxFinishReplicaRequest> {
    public static final TxFinishReplicaRequestSerializer INSTANCE = new TxFinishReplicaRequestSerializer();

    private TxFinishReplicaRequestSerializer() {
    }

    public boolean writeMessage(TxFinishReplicaRequest msg, MessageWriter writer) throws MessageMappingException {
        TxFinishReplicaRequestImpl message = (TxFinishReplicaRequestImpl)msg;
        writer.setMessageTypeInfo(TxMessagesTypeInfos.txFinishReplicaRequest());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)8)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeBoolean("commit", message.commit());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeMessage("commitPartitionId", (NetworkMessage)message.commitPartitionId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                boolean written = writer.writeHybridTimestamp("commitTimestamp", message.commitTimestamp());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                boolean written = writer.writeBoxedLong("enlistmentConsistencyToken", message.enlistmentConsistencyToken());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                boolean written = writer.writeMessage("groupId", (NetworkMessage)message.groupId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                boolean written = writer.writeMap("groups", message.groups(), MessageCollectionItemType.MSG, MessageCollectionItemType.MSG);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                boolean written = writer.writeHybridTimestamp("timestamp", message.timestamp());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 7: {
                boolean written = writer.writeUuid("txId", message.txId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

