/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.hlc.ClockService;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.InternalClusterNode;
import org.apache.ignite.internal.network.MessagingService;
import org.apache.ignite.internal.network.NetworkMessage;
import org.apache.ignite.internal.replicator.ReplicaService;
import org.apache.ignite.internal.replicator.ZonePartitionId;
import org.apache.ignite.internal.replicator.message.ReplicaMessageUtils;
import org.apache.ignite.internal.replicator.message.ReplicaMessagesFactory;
import org.apache.ignite.internal.replicator.message.ReplicaRequest;
import org.apache.ignite.internal.replicator.message.ReplicaResponse;
import org.apache.ignite.internal.replicator.message.ReplicationGroupIdMessage;
import org.apache.ignite.internal.replicator.message.ZonePartitionIdMessage;
import org.apache.ignite.internal.tx.PartitionEnlistment;
import org.apache.ignite.internal.tx.TransactionMeta;
import org.apache.ignite.internal.tx.TransactionResult;
import org.apache.ignite.internal.tx.impl.EnlistedPartitionGroup;
import org.apache.ignite.internal.tx.message.EnlistedPartitionGroupMessage;
import org.apache.ignite.internal.tx.message.PartitionEnlistmentMessage;
import org.apache.ignite.internal.tx.message.TxMessagesFactory;
import org.apache.ignite.internal.tx.message.TxStateResponse;
import org.apache.ignite.internal.tx.message.WriteIntentSwitchReplicatedInfo;
import org.jetbrains.annotations.Nullable;

public class TxMessageSender {
    private static final int RPC_TIMEOUT_MILLIS = 60000;
    private static final TxMessagesFactory TX_MESSAGES_FACTORY = new TxMessagesFactory();
    private static final ReplicaMessagesFactory REPLICA_MESSAGES_FACTORY = new ReplicaMessagesFactory();
    private final MessagingService messagingService;
    private final ReplicaService replicaService;
    private final ClockService clockService;

    public TxMessageSender(MessagingService messagingService, ReplicaService replicaService, ClockService clockService) {
        this.messagingService = messagingService;
        this.replicaService = replicaService;
        this.clockService = clockService;
    }

    public CompletableFuture<WriteIntentSwitchReplicatedInfo> switchWriteIntents(String primaryConsistentId, EnlistedPartitionGroup partition, UUID txId, boolean commit, @Nullable HybridTimestamp commitTimestamp) {
        return this.replicaService.invoke(primaryConsistentId, (ReplicaRequest)TX_MESSAGES_FACTORY.writeIntentSwitchReplicaRequest().groupId((ReplicationGroupIdMessage)ReplicaMessageUtils.toZonePartitionIdMessage((ReplicaMessagesFactory)REPLICA_MESSAGES_FACTORY, (ZonePartitionId)partition.groupId())).tableIds(partition.tableIds()).timestamp(this.clockService.now()).txId(txId).commit(commit).commitTimestamp(commitTimestamp).build());
    }

    public CompletableFuture<NetworkMessage> cleanup(String primaryConsistentId, @Nullable Collection<EnlistedPartitionGroup> enlistedPartitionGroups, UUID txId, boolean commit, @Nullable HybridTimestamp commitTimestamp) {
        return this.messagingService.invoke(primaryConsistentId, (NetworkMessage)TX_MESSAGES_FACTORY.txCleanupMessage().txId(txId).commit(commit).commitTimestamp(commitTimestamp).timestamp(this.clockService.now()).groups(TxMessageSender.toPartitionMessages(enlistedPartitionGroups)).build(), 60000L);
    }

    public CompletableFuture<TransactionResult> finish(String primaryConsistentId, ZonePartitionId commitPartition, Map<ZonePartitionId, PartitionEnlistment> enlistedPartitions, UUID txId, Long consistencyToken, boolean commit, @Nullable HybridTimestamp commitTimestamp) {
        ZonePartitionIdMessage commitPartitionIdMessage = ReplicaMessageUtils.toZonePartitionIdMessage((ReplicaMessagesFactory)REPLICA_MESSAGES_FACTORY, (ZonePartitionId)commitPartition);
        return this.replicaService.invoke(primaryConsistentId, (ReplicaRequest)TX_MESSAGES_FACTORY.txFinishReplicaRequest().txId(txId).commitPartitionId(commitPartitionIdMessage).timestamp(this.clockService.now()).groupId((ReplicationGroupIdMessage)ReplicaMessageUtils.toZonePartitionIdMessage((ReplicaMessagesFactory)REPLICA_MESSAGES_FACTORY, (ZonePartitionId)commitPartition)).groups(TxMessageSender.toEnlistedPartitionMessagesByGroupId(enlistedPartitions)).commit(commit).commitTimestamp(commitTimestamp).enlistmentConsistencyToken(consistencyToken).build());
    }

    public CompletableFuture<TransactionMeta> resolveTxStateFromCommitPartition(String primaryConsistentId, UUID txId, ZonePartitionId commitGrpId, Long consistencyToken) {
        return this.replicaService.invoke(primaryConsistentId, (ReplicaRequest)TX_MESSAGES_FACTORY.txStateCommitPartitionRequest().groupId((ReplicationGroupIdMessage)ReplicaMessageUtils.toZonePartitionIdMessage((ReplicaMessagesFactory)REPLICA_MESSAGES_FACTORY, (ZonePartitionId)commitGrpId)).txId(txId).enlistmentConsistencyToken(consistencyToken).build());
    }

    public CompletableFuture<TxStateResponse> resolveTxStateFromCoordinator(InternalClusterNode coordinatorClusterNode, UUID txId, HybridTimestamp timestamp) {
        return this.messagingService.invoke(coordinatorClusterNode, (NetworkMessage)TX_MESSAGES_FACTORY.txStateCoordinatorRequest().readTimestamp(timestamp).txId(txId).build(), 60000L).thenApply(resp -> {
            assert (resp instanceof TxStateResponse) : "Unsupported response type [type=" + resp.getClass().getSimpleName() + "]";
            return (TxStateResponse)resp;
        });
    }

    public CompletableFuture<ReplicaResponse> sendRecoveryCleanup(String primaryConsistentId, ZonePartitionId replicationGroupId) {
        return this.replicaService.invoke(primaryConsistentId, (ReplicaRequest)TX_MESSAGES_FACTORY.txCleanupRecoveryRequest().groupId((ReplicationGroupIdMessage)ReplicaMessageUtils.toZonePartitionIdMessage((ReplicaMessagesFactory)REPLICA_MESSAGES_FACTORY, (ZonePartitionId)replicationGroupId)).build());
    }

    public MessagingService messagingService() {
        return this.messagingService;
    }

    @Nullable
    private static List<EnlistedPartitionGroupMessage> toPartitionMessages(@Nullable Collection<EnlistedPartitionGroup> enlistedPartitionGroups) {
        if (enlistedPartitionGroups == null) {
            return null;
        }
        ArrayList<EnlistedPartitionGroupMessage> messages = new ArrayList<EnlistedPartitionGroupMessage>(enlistedPartitionGroups.size());
        for (EnlistedPartitionGroup partition : enlistedPartitionGroups) {
            messages.add(TX_MESSAGES_FACTORY.enlistedPartitionGroupMessage().groupId(ReplicaMessageUtils.toZonePartitionIdMessage((ReplicaMessagesFactory)REPLICA_MESSAGES_FACTORY, (ZonePartitionId)partition.groupId())).tableIds(partition.tableIds()).build());
        }
        return messages;
    }

    private static Map<ZonePartitionIdMessage, PartitionEnlistmentMessage> toEnlistedPartitionMessagesByGroupId(Map<ZonePartitionId, PartitionEnlistment> idEnlistedPartitions) {
        HashMap<ZonePartitionIdMessage, PartitionEnlistmentMessage> messages = new HashMap<ZonePartitionIdMessage, PartitionEnlistmentMessage>(idEnlistedPartitions.size());
        for (Map.Entry<ZonePartitionId, PartitionEnlistment> e : idEnlistedPartitions.entrySet()) {
            PartitionEnlistment enlistedPartition = e.getValue();
            messages.put(ReplicaMessageUtils.toZonePartitionIdMessage((ReplicaMessagesFactory)REPLICA_MESSAGES_FACTORY, (ZonePartitionId)e.getKey()), TX_MESSAGES_FACTORY.partitionEnlistmentMessage().primaryConsistentId(enlistedPartition.primaryNodeConsistentId()).tableIds(enlistedPartition.tableIds()).build());
        }
        return messages;
    }
}

