/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.impl;

import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import org.apache.ignite.cache.CacheStore;
import org.apache.ignite.cache.CacheStoreSession;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.hlc.HybridTimestampTracker;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.replicator.ZonePartitionId;
import org.apache.ignite.internal.tx.PendingTxPartitionEnlistment;
import org.apache.ignite.internal.tx.TransactionIds;
import org.apache.ignite.internal.tx.TxManager;
import org.apache.ignite.internal.tx.impl.IgniteAbstractTransactionImpl;
import org.apache.ignite.internal.tx.impl.TransactionsExceptionMapperUtil;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.tx.Transaction;
import org.apache.ignite.tx.TransactionException;
import org.jetbrains.annotations.Nullable;

public final class ReadWriteTransactionImpl
extends IgniteAbstractTransactionImpl {
    private static final AtomicReferenceFieldUpdater<ReadWriteTransactionImpl, ZonePartitionId> COMMIT_PART_UPDATER = AtomicReferenceFieldUpdater.newUpdater(ReadWriteTransactionImpl.class, ZonePartitionId.class, "commitPart");
    private final Map<ZonePartitionId, PendingTxPartitionEnlistment> enlisted = new ConcurrentHashMap<ZonePartitionId, PendingTxPartitionEnlistment>();
    @Nullable
    private volatile ZonePartitionId commitPart;
    private final ReentrantReadWriteLock enlistPartitionLock = new ReentrantReadWriteLock();
    private volatile CompletableFuture<Void> finishFuture;
    private boolean killed;
    private final Map<CacheStore, Map> enlistedStores = new ConcurrentHashMap<CacheStore, Map>();
    private boolean external;

    public ReadWriteTransactionImpl(TxManager txManager, HybridTimestampTracker observableTsTracker, UUID id, UUID txCoordinatorId, boolean implicit, long timeout, boolean external) {
        super(txManager, observableTsTracker, id, txCoordinatorId, implicit, timeout);
        this.external = external;
    }

    @Override
    public boolean assignCommitPartition(ZonePartitionId commitPartitionId) {
        return COMMIT_PART_UPDATER.compareAndSet(this, null, commitPartitionId);
    }

    @Override
    public ZonePartitionId commitPartition() {
        return this.commitPart;
    }

    @Override
    public PendingTxPartitionEnlistment enlistedPartition(ZonePartitionId partGroupId) {
        return this.enlisted.get(partGroupId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enlist(ZonePartitionId replicationGroupId, int tableId, String primaryNodeConsistentId, long consistencyToken) {
        if (!this.enlistPartitionLock.readLock().tryLock()) {
            this.failEnlist();
            assert (false);
        }
        try {
            this.checkEnlistPossibility();
            PendingTxPartitionEnlistment enlistment = this.enlisted.computeIfAbsent(replicationGroupId, k -> new PendingTxPartitionEnlistment(primaryNodeConsistentId, consistencyToken));
            enlistment.addTableId(tableId);
        }
        finally {
            this.enlistPartitionLock.readLock().unlock();
        }
    }

    private void failEnlist() {
        throw new TransactionException(ErrorGroups.Transactions.TX_ALREADY_FINISHED_ERR, IgniteStringFormatter.format((String)"Transaction is already finished [id={}, state={}].", (Object[])new Object[]{this.id(), this.state()}));
    }

    private void checkEnlistPossibility() {
        if (this.isFinishingOrFinished()) {
            this.failEnlist();
        }
    }

    public CompletableFuture<Void> commitAsync() {
        return TransactionsExceptionMapperUtil.convertToPublicFuture(this.finish(true, null, false, false), ErrorGroups.Transactions.TX_COMMIT_ERR);
    }

    public CompletableFuture<Void> rollbackAsync() {
        return TransactionsExceptionMapperUtil.convertToPublicFuture(this.finish(false, null, false, false), ErrorGroups.Transactions.TX_ROLLBACK_ERR);
    }

    @Override
    public CompletableFuture<Void> rollbackTimeoutExceededAsync() {
        return TransactionsExceptionMapperUtil.convertToPublicFuture(this.finish(false, null, false, true), ErrorGroups.Transactions.TX_ROLLBACK_ERR);
    }

    @Override
    public CompletableFuture<Void> finish(boolean commit, @Nullable HybridTimestamp executionTimestamp, boolean full, boolean timeoutExceeded) {
        assert (!commit || !timeoutExceeded) : "Transaction cannot commit with timeout exceeded.";
        if (this.finishFuture != null) {
            return this.finishFuture;
        }
        return this.finishInternal(commit, executionTimestamp, full, true, timeoutExceeded);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<Void> finishInternal(boolean commit, @Nullable HybridTimestamp executionTimestamp, boolean full, boolean isComplete, boolean timeoutExceeded) {
        this.enlistPartitionLock.writeLock().lock();
        try {
            if (this.finishFuture == null) {
                if (this.killed) {
                    if (isComplete) {
                        this.finishFuture = CompletableFutures.nullCompletedFuture();
                        CompletableFuture<Void> completableFuture = CompletableFuture.failedFuture((Throwable)new TransactionException(ErrorGroups.Transactions.TX_ALREADY_FINISHED_ERR, IgniteStringFormatter.format((String)"Transaction is killed [id={}, state={}].", (Object[])new Object[]{this.id(), this.state()})));
                        return completableFuture;
                    }
                    CompletableFuture completableFuture = CompletableFutures.nullCompletedFuture();
                    return completableFuture;
                }
                if (full) {
                    this.txManager.finishFull(this.observableTsTracker, this.id(), executionTimestamp, commit, timeoutExceeded);
                    if (isComplete) {
                        this.finishFuture = CompletableFutures.nullCompletedFuture();
                        this.timeoutExceeded = timeoutExceeded;
                    } else {
                        this.killed = true;
                    }
                } else {
                    CompletionStage fut = CompletableFutures.nullCompletedFuture();
                    if (commit && this.external && !this.enlistedStores.isEmpty()) {
                        CacheStoreSession ses = this.enlistedStores.keySet().iterator().next().beginSession();
                        Objects.requireNonNull(ses);
                        ses.setTransaction((Transaction)this);
                        for (Map.Entry entry : this.enlistedStores.entrySet()) {
                            CacheStore store = (CacheStore)entry.getKey();
                            Map value1 = (Map)entry.getValue();
                            for (Map.Entry entry0 : value1.entrySet()) {
                                Optional value = (Optional)entry0.getValue();
                                if (value.isEmpty()) {
                                    fut = ((CompletableFuture)fut).thenCompose(res -> store.deleteAsync(ses, entry0.getKey()));
                                    continue;
                                }
                                fut = ((CompletableFuture)fut).thenCompose(res -> store.writeAsync(ses, new AbstractMap.SimpleEntry(entry0.getKey(), value.get())));
                            }
                        }
                        fut = ((CompletableFuture)((CompletableFuture)fut).handle((ignored, err) -> {
                            if (err != null) {
                                return ses.finishAsync(false).handle((ignored0, err0) -> {
                                    if (err0 != null) {
                                        err.addSuppressed((Throwable)err0);
                                    }
                                    ExceptionUtils.sneakyThrow((Throwable)err);
                                    return null;
                                });
                            }
                            return ses.finishAsync(true);
                        })).thenCompose(Function.identity());
                    }
                    CompletionStage finishFutureInternal = ((CompletableFuture)((CompletableFuture)fut).handle((res, err) -> {
                        if (err != null) {
                            return this.txManager.finish(this.observableTsTracker, this.external ? null : this.commitPart, false, timeoutExceeded, false, this.enlisted, this.id()).handle((ignored, err0) -> {
                                if (err0 != null) {
                                    err.addSuppressed((Throwable)err0);
                                }
                                ExceptionUtils.sneakyThrow((Throwable)err);
                                return null;
                            });
                        }
                        return this.txManager.finish(this.observableTsTracker, this.external ? null : this.commitPart, commit, timeoutExceeded, false, this.enlisted, this.id());
                    })).thenCompose(Function.identity());
                    if (isComplete) {
                        this.finishFuture = ((CompletableFuture)finishFutureInternal).handle((unused, throwable) -> null);
                        this.timeoutExceeded = timeoutExceeded;
                    } else {
                        this.killed = true;
                    }
                    CompletionStage completionStage = finishFutureInternal;
                    return completionStage;
                }
            }
            CompletableFuture<Void> completableFuture = this.finishFuture;
            return completableFuture;
        }
        finally {
            this.enlistPartitionLock.writeLock().unlock();
        }
    }

    @Override
    public boolean isFinishingOrFinished() {
        return this.finishFuture != null;
    }

    public boolean isReadOnly() {
        return false;
    }

    public HybridTimestamp readTimestamp() {
        return null;
    }

    @Override
    public HybridTimestamp schemaTimestamp() {
        return TransactionIds.beginTimestamp(this.id());
    }

    @Override
    public CompletableFuture<Void> kill() {
        return this.finishInternal(false, null, false, false, false);
    }

    @Override
    public boolean isRolledBackWithTimeoutExceeded() {
        this.enlistPartitionLock.readLock().lock();
        try {
            boolean bl = this.timeoutExceeded;
            return bl;
        }
        finally {
            this.enlistPartitionLock.readLock().unlock();
        }
    }

    public void fail(TransactionException e) {
        this.finishFuture = CompletableFuture.failedFuture((Throwable)e);
    }

    @Override
    public synchronized <K, V> Map<K, Optional<V>> enlistStore(CacheStore<?, ?> store) {
        ConcurrentHashMap map = this.enlistedStores.get(store);
        if (map == null) {
            map = new ConcurrentHashMap();
            this.enlistedStores.put(store, map);
        }
        return map;
    }

    @Override
    public boolean external() {
        return this.external;
    }

    @Override
    public void external(boolean external) {
        this.external = external;
    }
}

