/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.impl;

import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.cache.CacheStore;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.hlc.HybridTimestampTracker;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.replicator.ZonePartitionId;
import org.apache.ignite.internal.tx.InternalTransaction;
import org.apache.ignite.internal.tx.PendingTxPartitionEnlistment;
import org.apache.ignite.internal.tx.TxState;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.tx.TransactionException;
import org.gridgain.lang.GridgainErrorGroups;
import org.jetbrains.annotations.Nullable;

public class ReadOnlyImplicitTransactionImpl
implements InternalTransaction {
    private static final UUID FAKE_ID = new UUID(0L, 0L);
    private final HybridTimestampTracker observableTsTracker;
    private final HybridTimestamp createTs;

    ReadOnlyImplicitTransactionImpl(HybridTimestampTracker observableTsTracker, HybridTimestamp createTs) {
        this.observableTsTracker = observableTsTracker;
        this.createTs = createTs;
    }

    @Override
    public UUID id() {
        return FAKE_ID;
    }

    @Override
    public TxState state() {
        return null;
    }

    @Override
    public UUID coordinatorId() {
        return null;
    }

    @Override
    public boolean implicit() {
        return true;
    }

    @Override
    public boolean remote() {
        return false;
    }

    @Override
    public long getTimeout() {
        return 0L;
    }

    @Override
    public boolean isRolledBackWithTimeoutExceeded() {
        return false;
    }

    @Override
    public void processDelayedAck(Object val, @Nullable Throwable err) {
    }

    public boolean isReadOnly() {
        return true;
    }

    public HybridTimestamp readTimestamp() {
        return null;
    }

    @Override
    public HybridTimestamp schemaTimestamp() {
        return this.createTs;
    }

    @Override
    public void enlist(ZonePartitionId replicationGroupId, int tableId, String primaryNodeConsistentId, long consistencyToken) {
    }

    @Override
    public PendingTxPartitionEnlistment enlistedPartition(ZonePartitionId replicationGroupId) {
        return null;
    }

    @Override
    public boolean assignCommitPartition(ZonePartitionId commitPartitionId) {
        return true;
    }

    @Override
    public ZonePartitionId commitPartition() {
        return null;
    }

    public CompletableFuture<Void> commitAsync() {
        return CompletableFutures.nullCompletedFuture();
    }

    public CompletableFuture<Void> rollbackAsync() {
        return CompletableFutures.nullCompletedFuture();
    }

    @Override
    public CompletableFuture<Void> rollbackTimeoutExceededAsync() {
        return CompletableFutures.nullCompletedFuture();
    }

    @Override
    public CompletableFuture<Void> finish(boolean commitIntent, HybridTimestamp executionTimestamp, boolean full, boolean timeoutExceeded) {
        this.observableTsTracker.update(executionTimestamp);
        return CompletableFutures.nullCompletedFuture();
    }

    @Override
    public boolean isFinishingOrFinished() {
        return false;
    }

    @Override
    public CompletableFuture<Void> kill() {
        return CompletableFutures.nullCompletedFuture();
    }

    public void commit() throws TransactionException {
    }

    public void rollback() throws TransactionException {
    }

    @Override
    public <K, V> Map<K, Optional<V>> enlistStore(CacheStore<?, ?> store) {
        throw new TransactionException(GridgainErrorGroups.Cache.TX_INCOMPATIBLE_OPERATION_ERR, IgniteStringFormatter.format((String)"Requested operation is incompatible with cache or table type [txId={}, cache={}]", (Object[])new Object[]{this.id(), true}));
    }

    @Override
    public boolean external() {
        return false;
    }

    @Override
    public void external(boolean external) {
        throw new UnsupportedOperationException();
    }
}

