/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import org.apache.ignite.configuration.NamedListView;
import org.apache.ignite.internal.configuration.SystemLocalConfiguration;
import org.apache.ignite.internal.configuration.SystemPropertyView;
import org.apache.ignite.internal.event.AbstractEventProducer;
import org.apache.ignite.internal.lang.IgniteBiTuple;
import org.apache.ignite.internal.tostring.IgniteToStringExclude;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.tx.DeadlockPreventionPolicy;
import org.apache.ignite.internal.tx.Lock;
import org.apache.ignite.internal.tx.LockException;
import org.apache.ignite.internal.tx.LockKey;
import org.apache.ignite.internal.tx.LockManager;
import org.apache.ignite.internal.tx.LockMode;
import org.apache.ignite.internal.tx.PossibleDeadlockOnLockAcquireException;
import org.apache.ignite.internal.tx.Waiter;
import org.apache.ignite.internal.tx.event.LockEvent;
import org.apache.ignite.internal.tx.event.LockEventParameters;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.IgniteStripedReadWriteLock;
import org.apache.ignite.lang.ErrorGroups;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class HeapLockManager
extends AbstractEventProducer<LockEvent, LockEventParameters>
implements LockManager {
    public static final int DEFAULT_SLOTS = 0x100000;
    public static final String LOCK_MAP_SIZE_PROPERTY_NAME = "lockMapSize";
    private static final int CONCURRENCY = Math.max(1, Runtime.getRuntime().availableProcessors() / 2);
    private final LongAdder lockTableSize = new LongAdder();
    private LockState removedLockState;
    private final int lockMapSize;
    private ConcurrentHashMap<LockKey, LockState> locks;
    private DeadlockPreventionPolicy deadlockPreventionPolicy;
    private Executor delayedExecutor;
    private final ConcurrentHashMap<UUID, ConcurrentLinkedQueue<Releasable>> txMap = new ConcurrentHashMap(1024);
    private final ConcurrentHashMap<Object, CoarseLockState> coarseMap = new ConcurrentHashMap();

    @TestOnly
    public static HeapLockManager smallInstance() {
        return new HeapLockManager(1024);
    }

    public HeapLockManager(SystemLocalConfiguration systemProperties) {
        this(HeapLockManager.intProperty(systemProperties, LOCK_MAP_SIZE_PROPERTY_NAME, 0x100000));
    }

    public HeapLockManager(int lockMapSize) {
        this.lockMapSize = lockMapSize;
    }

    private static int intProperty(SystemLocalConfiguration systemProperties, String name, int defaultValue) {
        SystemPropertyView property = (SystemPropertyView)((NamedListView)systemProperties.properties().value()).get(name);
        return property == null ? defaultValue : Integer.parseInt(property.propertyValue());
    }

    @Override
    public void start(DeadlockPreventionPolicy deadlockPreventionPolicy) {
        this.deadlockPreventionPolicy = deadlockPreventionPolicy;
        this.removedLockState = new LockState();
        this.delayedExecutor = deadlockPreventionPolicy.waitTimeout() > 0L ? CompletableFuture.delayedExecutor(deadlockPreventionPolicy.waitTimeout(), TimeUnit.MILLISECONDS) : null;
        this.locks = new ConcurrentHashMap(this.lockMapSize);
    }

    @Override
    public CompletableFuture<Lock> acquire(UUID txId, LockKey lockKey, LockMode lockMode) {
        LockState state;
        IgniteBiTuple<CompletableFuture<Void>, LockMode> futureTuple;
        assert (lockMode != null) : "Lock mode is null";
        if (lockKey.contextId() == null) {
            CoarseLockState state2 = this.coarseMap.computeIfAbsent(lockKey, key -> new CoarseLockState(lockKey));
            return state2.acquire(txId, lockMode);
        }
        do {
            if ((state = this.acquireLockState(lockKey)) != null) continue;
            return CompletableFuture.failedFuture((Throwable)((Object)new LockException(ErrorGroups.Transactions.ACQUIRE_LOCK_ERR, "Failed to acquire a lock due to lock table overflow [txId=" + txId + ", limit=" + this.lockMapSize + "]")));
        } while ((futureTuple = state.tryAcquire(txId, lockMode)).get1() == null);
        LockMode newLockMode = (LockMode)((Object)futureTuple.get2());
        return ((CompletableFuture)futureTuple.get1()).thenApply(res -> new Lock(lockKey, newLockMode, txId));
    }

    @Override
    @TestOnly
    public void release(Lock lock) {
        if (lock.lockKey().contextId() == null) {
            CoarseLockState lockState2 = this.coarseMap.get(lock.lockKey());
            if (lockState2 != null) {
                lockState2.release(lock);
            }
            return;
        }
        LockState state = this.lockState(lock.lockKey());
        if (state.tryRelease(lock.txId())) {
            this.locks.compute(lock.lockKey(), (k, v) -> this.adjustLockState(state, (LockState)v));
        }
    }

    @Override
    public void release(UUID txId, LockKey lockKey, LockMode lockMode) {
        assert (lockMode != null) : "Lock mode is null";
        if (lockKey.contextId() == null) {
            throw new IllegalArgumentException("Coarse locks don't support downgrading");
        }
        LockState state = this.lockState(lockKey);
        if (state.tryRelease(txId, lockMode)) {
            this.locks.compute(lockKey, (k, v) -> this.adjustLockState(state, (LockState)v));
        }
    }

    @Override
    public void releaseAll(UUID txId) {
        ConcurrentLinkedQueue<Releasable> states = this.txMap.remove(txId);
        if (states != null) {
            ArrayList<Releasable> delayed = new ArrayList<Releasable>(4);
            for (Releasable state : states) {
                LockKey key;
                if (state.coarse()) {
                    delayed.add(state);
                    continue;
                }
                if (!state.tryRelease(txId) || (key = state.key()) == null) continue;
                this.locks.compute(key, (k, v) -> this.adjustLockState((LockState)state, (LockState)v));
            }
            for (Releasable state : delayed) {
                state.tryRelease(txId);
            }
        }
    }

    @Override
    public Iterator<Lock> locks() {
        return this.txMap.entrySet().stream().flatMap(e -> HeapLockManager.collectLocksFromStates((UUID)e.getKey(), (ConcurrentLinkedQueue)e.getValue()).stream()).iterator();
    }

    @Override
    public Iterator<Lock> locks(UUID txId) {
        ConcurrentLinkedQueue<Releasable> lockStates = this.txMap.get(txId);
        return HeapLockManager.collectLocksFromStates(txId, lockStates).iterator();
    }

    private LockState lockState(LockKey key) {
        return this.locks.getOrDefault(key, this.removedLockState);
    }

    @Nullable
    private LockState acquireLockState(LockKey key) {
        return this.locks.computeIfAbsent(key, k -> {
            int acquiredLocks = this.lockTableSize.intValue();
            if (acquiredLocks < this.lockMapSize) {
                this.lockTableSize.increment();
                LockState v = new LockState();
                v.key = k;
                return v;
            }
            return null;
        });
    }

    @Override
    public Collection<UUID> queue(LockKey key) {
        return this.lockState(key).queue();
    }

    @Override
    public Waiter waiter(LockKey key, UUID txId) {
        return this.lockState(key).waiter(txId);
    }

    @Override
    public boolean isEmpty() {
        if (this.lockTableSize.sum() != 0L) {
            return false;
        }
        for (CoarseLockState value : this.coarseMap.values()) {
            if (!value.slockOwners.isEmpty()) {
                return false;
            }
            if (value.ixlockOwners.isEmpty()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private LockState adjustLockState(LockState state, LockState v) {
        if (v != state) {
            return v;
        }
        TreeMap<UUID, WaiterImpl> treeMap = v.waiters;
        synchronized (treeMap) {
            if (v.waiters.isEmpty()) {
                v.key = null;
                this.lockTableSize.decrement();
                return null;
            }
            return v;
        }
    }

    private void track(UUID txId, Releasable val) {
        this.txMap.compute(txId, (k, v) -> {
            if (v == null) {
                v = new ConcurrentLinkedQueue<Releasable>();
            }
            v.add(val);
            return v;
        });
    }

    private static List<Lock> collectLocksFromStates(UUID txId, ConcurrentLinkedQueue<Releasable> lockStates) {
        ArrayList<Lock> result = new ArrayList<Lock>();
        if (lockStates != null) {
            for (Releasable lockState : lockStates) {
                Lock lock = lockState.lock(txId);
                if (lock == null || lock.lockMode() == null) continue;
                result.add(lock);
            }
        }
        return result;
    }

    private static LockException abandonedLockException(UUID locker, UUID holder) {
        return new LockException(ErrorGroups.Transactions.ACQUIRE_LOCK_ERR, "Failed to acquire an abandoned lock due to a possible deadlock [locker=" + locker + ", holder=" + holder + "]");
    }

    private static int spread(int h) {
        return (h ^ h >>> 16) & Integer.MAX_VALUE;
    }

    @TestOnly
    public LockState[] getSlots() {
        return this.locks.values().toArray(new LockState[0]);
    }

    public int available() {
        return Math.max(this.lockMapSize - this.lockTableSize.intValue(), 0);
    }

    public class LockState
    implements Releasable {
        private final TreeMap<UUID, WaiterImpl> waiters;
        private volatile LockKey key;

        LockState() {
            Comparator<UUID> txComparator = HeapLockManager.this.deadlockPreventionPolicy.txIdComparator() != null ? HeapLockManager.this.deadlockPreventionPolicy.txIdComparator() : UUID::compareTo;
            this.waiters = new TreeMap(txComparator);
        }

        boolean isUsed() {
            return this.key != null;
        }

        @Override
        public LockKey key() {
            return this.key;
        }

        @Override
        public Lock lock(UUID txId) {
            Waiter waiter = this.waiters.get(txId);
            if (waiter != null) {
                return new Lock(this.key, waiter.lockMode(), txId);
            }
            return null;
        }

        @Override
        public boolean coarse() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        IgniteBiTuple<CompletableFuture<Void>, LockMode> tryAcquire(UUID txId, LockMode lockMode) {
            assert (lockMode != null) : "Lock mode is null";
            WaiterImpl waiter = new WaiterImpl(txId, lockMode);
            TreeMap<UUID, WaiterImpl> treeMap = this.waiters;
            synchronized (treeMap) {
                if (!this.isUsed()) {
                    return new IgniteBiTuple(null, (Object)lockMode);
                }
                WaiterImpl prev = this.waiters.put(txId, waiter);
                if (prev != null) {
                    if (prev.locked() && prev.lockMode().allowReenter(lockMode)) {
                        waiter.lock();
                        waiter.upgrade(prev);
                        return new IgniteBiTuple((Object)CompletableFutures.nullCompletedFuture(), (Object)prev.lockMode());
                    }
                    waiter.upgrade(prev);
                    assert (prev.lockMode() == waiter.lockMode()) : "Lock modes are incorrect [prev=" + prev.lockMode() + ", new=" + waiter.lockMode() + "]";
                }
                if (!this.isWaiterReadyToNotify(waiter, false)) {
                    if (HeapLockManager.this.deadlockPreventionPolicy.waitTimeout() > 0L) {
                        this.setWaiterTimeout(waiter);
                    }
                    if (prev == null) {
                        HeapLockManager.this.track(waiter.txId, this);
                    }
                    return new IgniteBiTuple(waiter.fut, (Object)waiter.lockMode());
                }
                if (!waiter.locked()) {
                    this.waiters.remove(waiter.txId());
                } else if (waiter.hasLockIntent()) {
                    waiter.refuseIntent();
                } else if (prev == null) {
                    HeapLockManager.this.track(waiter.txId, this);
                }
            }
            waiter.notifyLocked();
            return new IgniteBiTuple(waiter.fut, (Object)waiter.lockMode());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int waitersCount() {
            TreeMap<UUID, WaiterImpl> treeMap = this.waiters;
            synchronized (treeMap) {
                return this.waiters.size();
            }
        }

        private boolean isWaiterReadyToNotify(WaiterImpl waiter, boolean skipFail) {
            LockMode currentlyAcquiredLockMode;
            WaiterImpl tmp;
            LockMode intendedLockMode = waiter.intendedLockMode();
            assert (intendedLockMode != null) : "Intended lock mode is null";
            for (Map.Entry entry : this.waiters.tailMap(waiter.txId(), false).entrySet()) {
                tmp = (WaiterImpl)entry.getValue();
                currentlyAcquiredLockMode = tmp.lockMode;
                if (currentlyAcquiredLockMode == null || currentlyAcquiredLockMode.isCompatible(intendedLockMode)) continue;
                if (this.conflictFound(waiter.txId())) {
                    waiter.fail(HeapLockManager.abandonedLockException(waiter.txId, tmp.txId));
                    return true;
                }
                if (!HeapLockManager.this.deadlockPreventionPolicy.usePriority() && HeapLockManager.this.deadlockPreventionPolicy.waitTimeout() == 0L) {
                    waiter.fail(new PossibleDeadlockOnLockAcquireException(waiter.txId, tmp.txId, intendedLockMode, currentlyAcquiredLockMode));
                    return true;
                }
                return false;
            }
            for (Map.Entry<Object, Object> entry : this.waiters.headMap(waiter.txId()).entrySet()) {
                tmp = (WaiterImpl)entry.getValue();
                currentlyAcquiredLockMode = tmp.lockMode;
                if (currentlyAcquiredLockMode == null || currentlyAcquiredLockMode.isCompatible(intendedLockMode)) continue;
                if (skipFail) {
                    return false;
                }
                if (this.conflictFound(waiter.txId())) {
                    waiter.fail(HeapLockManager.abandonedLockException(waiter.txId, tmp.txId));
                    return true;
                }
                if (HeapLockManager.this.deadlockPreventionPolicy.waitTimeout() == 0L) {
                    waiter.fail(new PossibleDeadlockOnLockAcquireException(waiter.txId, tmp.txId, intendedLockMode, currentlyAcquiredLockMode));
                    return true;
                }
                return false;
            }
            waiter.lock();
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean tryRelease(UUID txId) {
            List<WaiterImpl> toNotify;
            TreeMap<UUID, WaiterImpl> treeMap = this.waiters;
            synchronized (treeMap) {
                toNotify = this.release(txId);
            }
            for (WaiterImpl waiter : toNotify) {
                waiter.notifyLocked();
            }
            return this.key != null && this.waitersCount() == 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean tryRelease(UUID txId, LockMode lockMode) {
            assert (lockMode != null) : "Lock mode is null";
            List<Object> toNotify = Collections.emptyList();
            TreeMap<UUID, WaiterImpl> treeMap = this.waiters;
            synchronized (treeMap) {
                WaiterImpl waiter = this.waiters.get(txId);
                if (waiter != null) {
                    assert (LockMode.supremum(lockMode, waiter.lockMode()) == waiter.lockMode()) : "The lock is not locked in specified mode [mode=" + lockMode + ", locked=" + waiter.lockMode() + "]";
                    LockMode modeFromDowngrade = waiter.recalculateMode(lockMode);
                    if (!waiter.locked() && !waiter.hasLockIntent()) {
                        toNotify = this.release(txId);
                    } else if (modeFromDowngrade != waiter.lockMode()) {
                        toNotify = this.unlockCompatibleWaiters();
                    }
                }
            }
            for (WaiterImpl waiter : toNotify) {
                waiter.notifyLocked();
            }
            return this.key != null && this.waitersCount() == 0;
        }

        private List<WaiterImpl> release(UUID txId) {
            this.waiters.remove(txId);
            if (this.waiters.isEmpty()) {
                return Collections.emptyList();
            }
            return this.unlockCompatibleWaiters();
        }

        private List<WaiterImpl> unlockCompatibleWaiters() {
            WaiterImpl tmp;
            if (!HeapLockManager.this.deadlockPreventionPolicy.usePriority() && HeapLockManager.this.deadlockPreventionPolicy.waitTimeout() == 0L) {
                return Collections.emptyList();
            }
            ArrayList<WaiterImpl> toNotify = new ArrayList<WaiterImpl>();
            HashSet<UUID> toFail = new HashSet<UUID>();
            for (Map.Entry<UUID, WaiterImpl> entry : this.waiters.entrySet()) {
                tmp = entry.getValue();
                if (!tmp.hasLockIntent() || !this.isWaiterReadyToNotify(tmp, true)) continue;
                assert (!tmp.hasLockIntent()) : "This waiter in not locked for notification [waiter=" + tmp + "]";
                toNotify.add(tmp);
            }
            if (HeapLockManager.this.deadlockPreventionPolicy.usePriority() && HeapLockManager.this.deadlockPreventionPolicy.waitTimeout() >= 0L) {
                for (Map.Entry<UUID, WaiterImpl> entry : this.waiters.entrySet()) {
                    tmp = entry.getValue();
                    if (!tmp.hasLockIntent() || !this.isWaiterReadyToNotify(tmp, false)) continue;
                    assert (tmp.hasLockIntent()) : "Only failed waiter can be notified here [waiter=" + tmp + "]";
                    toNotify.add(tmp);
                    toFail.add(tmp.txId());
                }
                for (UUID failTx : toFail) {
                    WaiterImpl w = this.waiters.get(failTx);
                    if (w.locked()) {
                        w.refuseIntent();
                        continue;
                    }
                    this.waiters.remove(failTx);
                }
            }
            return toNotify;
        }

        private void setWaiterTimeout(WaiterImpl waiter) {
            HeapLockManager.this.delayedExecutor.execute(() -> {
                if (!waiter.fut.isDone()) {
                    waiter.fut.completeExceptionally((Throwable)((Object)new LockException(ErrorGroups.Transactions.ACQUIRE_LOCK_TIMEOUT_ERR, "Failed to acquire a lock due to timeout [txId=" + waiter.txId() + ", waiter=" + waiter + ", timeout=" + HeapLockManager.this.deadlockPreventionPolicy.waitTimeout() + "]")));
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection<UUID> queue() {
            TreeMap<UUID, WaiterImpl> treeMap = this.waiters;
            synchronized (treeMap) {
                return new ArrayList<UUID>(this.waiters.keySet());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Waiter waiter(UUID txId) {
            TreeMap<UUID, WaiterImpl> treeMap = this.waiters;
            synchronized (treeMap) {
                return this.waiters.get(txId);
            }
        }

        private boolean conflictFound(UUID acquirerTx) {
            CompletableFuture eventResult = HeapLockManager.this.fireEvent(LockEvent.LOCK_CONFLICT, new LockEventParameters(acquirerTx, this.allLockHolderTxs()));
            assert (eventResult.isDone()) : "Async lock conflict handling is not supported";
            return eventResult.isCompletedExceptionally();
        }

        private Set<UUID> allLockHolderTxs() {
            return this.waiters.keySet();
        }
    }

    public class CoarseLockState
    implements Releasable {
        private final IgniteStripedReadWriteLock stripedLock = new IgniteStripedReadWriteLock(CONCURRENCY);
        private final ConcurrentHashMap<UUID, Lock> ixlockOwners = new ConcurrentHashMap();
        private final Map<UUID, IgniteBiTuple<Lock, CompletableFuture<Lock>>> slockWaiters = new HashMap<UUID, IgniteBiTuple<Lock, CompletableFuture<Lock>>>();
        private final ConcurrentHashMap<UUID, Lock> slockOwners = new ConcurrentHashMap();
        private final LockKey lockKey;
        private final Comparator<UUID> txComparator;

        CoarseLockState(LockKey lockKey) {
            this.lockKey = lockKey;
            this.txComparator = HeapLockManager.this.deadlockPreventionPolicy.txIdComparator() != null ? HeapLockManager.this.deadlockPreventionPolicy.txIdComparator() : UUID::compareTo;
        }

        @Override
        public boolean tryRelease(UUID txId) {
            Lock lock = this.lock(txId);
            this.release(lock);
            return false;
        }

        @Override
        public LockKey key() {
            return this.lockKey;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Lock lock(UUID txId) {
            Lock lock = this.ixlockOwners.get(txId);
            if (lock != null) {
                return lock;
            }
            int idx = Math.floorMod(HeapLockManager.spread(txId.hashCode()), CONCURRENCY);
            this.stripedLock.readLock(idx).lock();
            try {
                lock = this.slockOwners.get(txId);
                if (lock != null) {
                    Lock lock2 = lock;
                    return lock2;
                }
                IgniteBiTuple<Lock, CompletableFuture<Lock>> tuple = this.slockWaiters.get(txId);
                if (tuple != null) {
                    Lock lock3 = (Lock)tuple.get1();
                    return lock3;
                }
            }
            finally {
                this.stripedLock.readLock(idx).unlock();
            }
            return null;
        }

        @Override
        public boolean coarse() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CompletableFuture<Lock> acquire(UUID txId, LockMode lockMode) {
            switch (lockMode) {
                case S: {
                    this.stripedLock.writeLock().lock();
                    try {
                        if (!this.ixlockOwners.isEmpty()) {
                            if (this.ixlockOwners.containsKey(txId)) {
                                if (this.ixlockOwners.size() == 1) {
                                    HeapLockManager.this.track(txId, this);
                                    Lock lock = new Lock(this.lockKey, lockMode, txId);
                                    this.slockOwners.putIfAbsent(txId, lock);
                                    CompletableFuture<Lock> completableFuture = CompletableFuture.completedFuture(lock);
                                    return completableFuture;
                                }
                                for (Lock lock : this.ixlockOwners.values()) {
                                    if (lock.txId().equals(txId)) continue;
                                    CompletableFuture<Lock> completableFuture = this.notifyAndFail(txId, lock.txId(), lockMode, lock.lockMode());
                                    return completableFuture;
                                }
                                assert (false) : "Should not reach here";
                            }
                            if (HeapLockManager.this.deadlockPreventionPolicy.usePriority()) {
                                for (Lock lock : this.ixlockOwners.values()) {
                                    if (this.txComparator.compare(lock.txId(), txId) >= 0) continue;
                                    CompletableFuture<Lock> completableFuture = this.notifyAndFail(txId, lock.txId(), lockMode, lock.lockMode());
                                    return completableFuture;
                                }
                            }
                            HeapLockManager.this.track(txId, this);
                            CompletableFuture fut = new CompletableFuture();
                            IgniteBiTuple<Lock, CompletableFuture<Lock>> prev = this.slockWaiters.putIfAbsent(txId, (IgniteBiTuple<Lock, CompletableFuture<Lock>>)new IgniteBiTuple((Object)new Lock(this.lockKey, lockMode, txId), fut));
                            CompletableFuture completableFuture = prev == null ? fut : (CompletableFuture)prev.get2();
                            return completableFuture;
                        }
                        Lock lock = new Lock(this.lockKey, lockMode, txId);
                        Lock prev = this.slockOwners.putIfAbsent(txId, lock);
                        if (prev == null) {
                            HeapLockManager.this.track(txId, this);
                        }
                        CompletableFuture<Lock> completableFuture = CompletableFuture.completedFuture(lock);
                        return completableFuture;
                    }
                    finally {
                        this.stripedLock.writeLock().unlock();
                    }
                }
                case IX: {
                    int idx = Math.floorMod(HeapLockManager.spread(txId.hashCode()), CONCURRENCY);
                    this.stripedLock.readLock(idx).lock();
                    try {
                        if (!this.slockOwners.isEmpty()) {
                            if (this.slockOwners.containsKey(txId)) {
                                if (this.slockOwners.size() == 1) {
                                    HeapLockManager.this.track(txId, this);
                                    Lock lock2 = new Lock(this.lockKey, lockMode, txId);
                                    this.ixlockOwners.putIfAbsent(txId, lock2);
                                    CompletableFuture<Lock> completableFuture = CompletableFuture.completedFuture(lock2);
                                    return completableFuture;
                                }
                                for (Lock lock : this.slockOwners.values()) {
                                    if (lock.txId().equals(txId)) continue;
                                    CompletableFuture<Lock> completableFuture = this.notifyAndFail(txId, lock.txId(), lockMode, lock.lockMode());
                                    return completableFuture;
                                }
                                assert (false) : "Should not reach here";
                            }
                            Map.Entry<UUID, Lock> holderEntry = this.slockOwners.entrySet().iterator().next();
                            CompletableFuture<Lock> completableFuture = this.notifyAndFail(txId, holderEntry.getKey(), lockMode, holderEntry.getValue().lockMode());
                            return completableFuture;
                        }
                        Lock lock = new Lock(this.lockKey, lockMode, txId);
                        Lock lock2 = this.ixlockOwners.putIfAbsent(txId, lock);
                        if (lock2 == null) {
                            HeapLockManager.this.track(txId, this);
                        }
                        CompletableFuture<Lock> completableFuture = CompletableFuture.completedFuture(lock);
                        return completableFuture;
                    }
                    finally {
                        this.stripedLock.readLock(idx).unlock();
                    }
                }
            }
            assert (false) : "Unsupported coarse lock mode: " + lockMode;
            return null;
        }

        private Set<UUID> allLockHolderTxs() {
            return CollectionUtils.union((Set)this.ixlockOwners.keySet(), (Set)this.slockOwners.keySet());
        }

        CompletableFuture<Lock> notifyAndFail(UUID failedToAcquireLockTxId, UUID currentLockHolderTxId, LockMode attemptedLockModeToAcquireWith, LockMode currentlyAcquiredLockMode) {
            CompletableFuture<Lock> failedFuture = new CompletableFuture<Lock>();
            HeapLockManager.this.fireEvent(LockEvent.LOCK_CONFLICT, new LockEventParameters(failedToAcquireLockTxId, this.allLockHolderTxs())).whenComplete((v, ex) -> {
                if (ex != null) {
                    failedFuture.completeExceptionally((Throwable)((Object)HeapLockManager.abandonedLockException(failedToAcquireLockTxId, currentLockHolderTxId)));
                } else {
                    failedFuture.completeExceptionally((Throwable)((Object)new PossibleDeadlockOnLockAcquireException(failedToAcquireLockTxId, currentLockHolderTxId, attemptedLockModeToAcquireWith, currentlyAcquiredLockMode)));
                }
            });
            return failedFuture;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release(@Nullable Lock lock) {
            if (lock == null) {
                return;
            }
            switch (lock.lockMode()) {
                case S: {
                    IgniteBiTuple<Lock, CompletableFuture<Lock>> waiter = null;
                    this.stripedLock.writeLock().lock();
                    try {
                        Lock removed = this.slockOwners.remove(lock.txId());
                        if (removed == null && (waiter = this.slockWaiters.remove(lock.txId())) != null) {
                            removed = (Lock)waiter.get1();
                        }
                        assert (removed != null) : "Attempt to release not requested lock: " + lock.txId();
                    }
                    finally {
                        this.stripedLock.writeLock().unlock();
                    }
                    if (waiter == null) break;
                    ((CompletableFuture)waiter.get2()).complete((Lock)waiter.get1());
                    break;
                }
                case IX: {
                    HashMap<UUID, IgniteBiTuple<Lock, CompletableFuture<Lock>>> wakeups;
                    int idx = Math.floorMod(HeapLockManager.spread(lock.txId().hashCode()), CONCURRENCY);
                    this.stripedLock.readLock(idx).lock();
                    try {
                        Lock removed = this.ixlockOwners.remove(lock.txId());
                        assert (removed != null) : "Attempt to release not acquired lock: " + lock.txId();
                        if (this.slockWaiters.isEmpty()) {
                            return;
                        }
                        if (!this.ixlockOwners.isEmpty()) {
                            assert (this.slockOwners.isEmpty() || this.slockOwners.containsKey(lock.txId()));
                            return;
                        }
                        wakeups = new HashMap<UUID, IgniteBiTuple<Lock, CompletableFuture<Lock>>>(this.slockWaiters);
                        this.slockWaiters.clear();
                        for (IgniteBiTuple value : wakeups.values()) {
                            this.slockOwners.put(((Lock)value.getKey()).txId(), (Lock)value.getKey());
                        }
                    }
                    finally {
                        this.stripedLock.readLock(idx).unlock();
                    }
                    for (Map.Entry entry : wakeups.entrySet()) {
                        ((CompletableFuture)((IgniteBiTuple)entry.getValue()).get2()).complete((Lock)((IgniteBiTuple)entry.getValue()).get1());
                    }
                    break;
                }
                default: {
                    assert (false) : "Unsupported coarse unlock mode: " + lock.lockMode();
                    break;
                }
            }
        }
    }

    static interface Releasable {
        public boolean tryRelease(UUID var1);

        public LockKey key();

        @Nullable
        public Lock lock(UUID var1);

        public boolean coarse();
    }

    private static class WaiterImpl
    implements Comparable<WaiterImpl>,
    Waiter {
        private final Map<LockMode, Integer> locks = new EnumMap<LockMode, Integer>(LockMode.class);
        private final Set<LockMode> intendedLocks = EnumSet.noneOf(LockMode.class);
        @IgniteToStringExclude
        private CompletableFuture<Void> fut = new CompletableFuture();
        private final UUID txId;
        @Nullable
        private LockMode intendedLockMode;
        private LockMode lockMode;
        private LockException ex;

        WaiterImpl(UUID txId, LockMode lockMode) {
            this.txId = txId;
            this.intendedLockMode = lockMode;
            this.locks.put(lockMode, 1);
            this.intendedLocks.add(lockMode);
        }

        void addLock(LockMode lockMode, int increment) {
            this.locks.merge(lockMode, increment, Integer::sum);
        }

        private boolean removeLock(LockMode lockMode) {
            Integer counter = this.locks.get((Object)lockMode);
            if (counter == null || counter < 2) {
                this.locks.remove((Object)lockMode);
                return true;
            }
            this.locks.put(lockMode, counter - 1);
            return false;
        }

        LockMode recalculateMode(LockMode modeToRemove) {
            if (!this.removeLock(modeToRemove)) {
                return this.lockMode;
            }
            return this.recalculate();
        }

        private LockMode recalculate() {
            LockMode newIntendedLockMode = null;
            LockMode newLockMode = null;
            for (LockMode mode : this.locks.keySet()) {
                assert (mode != null) : "Lock mode is null";
                assert (this.locks.get((Object)mode) > 0) : "Incorrect lock counter [txId=" + this.txId + ", mode=" + mode + "]";
                if (this.intendedLocks.contains((Object)mode)) {
                    newIntendedLockMode = newIntendedLockMode == null ? mode : LockMode.supremum(newIntendedLockMode, mode);
                    continue;
                }
                newLockMode = newLockMode == null ? mode : LockMode.supremum(newLockMode, mode);
            }
            LockMode mode = this.lockMode;
            this.lockMode = newLockMode;
            this.intendedLockMode = newLockMode != null && newIntendedLockMode != null ? LockMode.supremum(newLockMode, newIntendedLockMode) : newIntendedLockMode;
            return mode;
        }

        void upgrade(WaiterImpl other) {
            this.intendedLocks.addAll(other.intendedLocks);
            other.locks.forEach(this::addLock);
            this.recalculate();
            if (other.hasLockIntent()) {
                this.fut = other.fut;
            }
        }

        void refuseIntent() {
            for (LockMode mode : this.intendedLocks) {
                this.locks.remove((Object)mode);
            }
            this.intendedLocks.clear();
            this.intendedLockMode = null;
        }

        @Override
        public int compareTo(WaiterImpl o) {
            return this.txId.compareTo(o.txId);
        }

        private void notifyLocked() {
            if (this.ex != null) {
                this.fut.completeExceptionally((Throwable)((Object)this.ex));
            } else {
                assert (this.lockMode != null) : "Lock mode is null";
                this.fut.complete(null);
            }
        }

        @Override
        public boolean locked() {
            return this.lockMode != null;
        }

        boolean hasLockIntent() {
            return this.intendedLockMode != null;
        }

        @Override
        public LockMode lockMode() {
            return this.lockMode;
        }

        @Override
        @Nullable
        public LockMode intendedLockMode() {
            return this.intendedLockMode;
        }

        private void lock() {
            assert (this.intendedLockMode != null) : "Intended lock mode is null";
            this.lockMode = this.intendedLockMode;
            this.intendedLockMode = null;
            this.intendedLocks.clear();
        }

        private void fail(LockException e) {
            this.ex = e;
        }

        @Override
        public UUID txId() {
            return this.txId;
        }

        public boolean equals(Object o) {
            return o instanceof WaiterImpl && this.compareTo((WaiterImpl)o) == 0;
        }

        public int hashCode() {
            return this.txId.hashCode();
        }

        public String toString() {
            return S.toString(WaiterImpl.class, (Object)this, (String)"granted", (Object)(this.fut.isDone() && !this.fut.isCompletedExceptionally() ? 1 : 0));
        }
    }
}

