/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.message;

import java.lang.constant.Constable;
import java.util.UUID;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.internal.replicator.message.ReplicationGroupIdMessage;
import org.apache.ignite.internal.tx.TxState;
import org.apache.ignite.internal.tx.message.TxMessagesFactory;
import org.apache.ignite.internal.tx.message.TxMessagesTypeInfos;
import org.apache.ignite.internal.tx.message.TxStateMetaAbandonedMessage;
import org.apache.ignite.internal.tx.message.TxStateMetaAbandonedMessageBuilder;

class TxStateMetaAbandonedMessageDeserializer
implements MessageDeserializer<TxStateMetaAbandonedMessage> {
    private final TxStateMetaAbandonedMessageBuilder msg;

    TxStateMetaAbandonedMessageDeserializer(TxMessagesFactory messageFactory) {
        this.msg = messageFactory.txStateMetaAbandonedMessage();
    }

    public Class<TxStateMetaAbandonedMessage> klass() {
        return TxStateMetaAbandonedMessage.class;
    }

    public TxStateMetaAbandonedMessage getMessage() {
        return this.msg.buildDeserialized();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(TxMessagesTypeInfos.txStateMetaAbandonedMessage());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                Constable tmp = reader.readBoxedLong("cleanupCompletionTimestamp");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.cleanupCompletionTimestamp((Long)tmp);
                }
                reader.incrementState();
            }
            case 1: {
                Constable tmp = (ReplicationGroupIdMessage)reader.readMessage("commitPartitionId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.commitPartitionId((ReplicationGroupIdMessage)tmp);
                }
                reader.incrementState();
            }
            case 2: {
                Constable tmp = reader.readHybridTimestamp("commitTimestamp");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.commitTimestamp((HybridTimestamp)tmp);
                }
                reader.incrementState();
            }
            case 3: {
                Constable tmp = reader.readBoxedLong("initialVacuumObservationTimestamp");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.initialVacuumObservationTimestamp((Long)tmp);
                }
                reader.incrementState();
            }
            case 4: {
                Constable tmp = reader.readBoxedBoolean("isFinishedDueToTimeout");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.isFinishedDueToTimeout((Boolean)tmp);
                }
                reader.incrementState();
            }
            case 5: {
                long tmp = reader.readLong("lastAbandonedMarkerTs");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.lastAbandonedMarkerTs(tmp);
                reader.incrementState();
            }
            case 6: {
                UUID tmp = reader.readUuid("txCoordinatorId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.txCoordinatorId(tmp);
                }
                reader.incrementState();
            }
            case 7: {
                TxState tmp;
                int shiftedId = reader.readInt("txState");
                if (!reader.isLastRead()) {
                    return false;
                }
                TxState txState = tmp = shiftedId == 0 ? null : TxState.fromId(shiftedId - 1);
                if (tmp != null) {
                    this.msg.txState(tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(TxStateMetaAbandonedMessage.class);
    }
}

