/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.message;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.tx.message.CleanupReplicatedInfoMessage;
import org.apache.ignite.internal.tx.message.TxCleanupMessageResponse;
import org.apache.ignite.internal.tx.message.TxCleanupMessageResponseBuilder;
import org.apache.ignite.internal.tx.message.TxCleanupMessageResponseSerializer;

public class TxCleanupMessageResponseImpl
implements TxCleanupMessageResponse,
Cloneable {
    public static final short GROUP_TYPE = 5;
    public static final short TYPE = 8;
    @IgniteToStringInclude
    private final CleanupReplicatedInfoMessage result;
    @IgniteToStringInclude
    private final HybridTimestamp timestamp;

    private TxCleanupMessageResponseImpl(CleanupReplicatedInfoMessage result, HybridTimestamp timestamp) {
        this.result = result;
        this.timestamp = timestamp;
    }

    @Override
    public CleanupReplicatedInfoMessage result() {
        return this.result;
    }

    public HybridTimestamp timestamp() {
        return this.timestamp;
    }

    public MessageSerializer serializer() {
        return TxCleanupMessageResponseSerializer.INSTANCE;
    }

    public short groupType() {
        return 5;
    }

    public String toString() {
        return S.toString(TxCleanupMessageResponseImpl.class, (Object)this);
    }

    public short messageType() {
        return 8;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TxCleanupMessageResponseImpl otherMessage = (TxCleanupMessageResponseImpl)other;
        return Objects.equals(this.result, otherMessage.result) && Objects.equals(this.timestamp, otherMessage.timestamp);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.result, this.timestamp);
        return result;
    }

    public TxCleanupMessageResponseImpl clone() {
        try {
            return (TxCleanupMessageResponseImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static TxCleanupMessageResponseBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.result != null) {
            this.result.prepareMarshal(usedDescriptors, marshaller);
        }
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.result != null) {
            this.result.unmarshal(marshaller, descriptorsObj);
        }
    }

    private static class Builder
    implements TxCleanupMessageResponseBuilder {
        private CleanupReplicatedInfoMessage result;
        private HybridTimestamp timestamp;

        private Builder() {
        }

        @Override
        public TxCleanupMessageResponseBuilder result(CleanupReplicatedInfoMessage result) {
            this.result = result;
            return this;
        }

        @Override
        public TxCleanupMessageResponseBuilder timestamp(HybridTimestamp timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public CleanupReplicatedInfoMessage result() {
            return this.result;
        }

        @Override
        public HybridTimestamp timestamp() {
            return this.timestamp;
        }

        @Override
        public TxCleanupMessageResponse build() {
            return new TxCleanupMessageResponseImpl(this.result, this.timestamp);
        }

        @Override
        public TxCleanupMessageResponse buildDeserialized() {
            return new TxCleanupMessageResponseImpl(this.result, this.timestamp);
        }
    }
}

