/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.impl;

import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.apache.ignite.internal.hlc.HybridTimestampTracker;
import org.apache.ignite.internal.tx.InternalTransaction;
import org.apache.ignite.internal.tx.TxManager;
import org.apache.ignite.internal.tx.TxState;
import org.apache.ignite.internal.tx.TxStateMeta;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.tx.TransactionException;
import org.jetbrains.annotations.Nullable;

public abstract class IgniteAbstractTransactionImpl
implements InternalTransaction {
    private final UUID id;
    protected final TxManager txManager;
    protected final HybridTimestampTracker observableTsTracker;
    private final UUID coordinatorId;
    private final boolean implicit;
    protected final long timeout;
    protected volatile boolean timeoutExceeded;

    public IgniteAbstractTransactionImpl(TxManager txManager, HybridTimestampTracker observableTsTracker, UUID id, UUID coordinatorId, boolean implicit, long timeout) {
        this.txManager = txManager;
        this.observableTsTracker = observableTsTracker;
        this.id = id;
        this.coordinatorId = coordinatorId;
        this.implicit = implicit;
        this.timeout = timeout;
    }

    @Override
    public UUID id() {
        return this.id;
    }

    @Override
    public UUID coordinatorId() {
        return this.coordinatorId;
    }

    @Override
    public boolean implicit() {
        return this.implicit;
    }

    @Override
    @Nullable
    public TxState state() {
        TxStateMeta meta = this.txManager.stateMeta(this.id);
        return meta == null ? null : meta.txState();
    }

    public void commit() throws TransactionException {
        try {
            this.commitAsync().get();
        }
        catch (ExecutionException e) {
            throw (RuntimeException)ExceptionUtils.sneakyThrow((Throwable)IgniteAbstractTransactionImpl.tryToCopyExceptionWithCause(e));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw (TransactionException)ExceptionUtils.withCause(TransactionException::new, (int)ErrorGroups.Transactions.TX_COMMIT_ERR, (Throwable)e);
        }
    }

    public void rollback() throws TransactionException {
        try {
            this.rollbackAsync().get();
        }
        catch (ExecutionException e) {
            throw (RuntimeException)ExceptionUtils.sneakyThrow((Throwable)IgniteAbstractTransactionImpl.tryToCopyExceptionWithCause(e));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw (TransactionException)ExceptionUtils.withCause(TransactionException::new, (int)ErrorGroups.Transactions.TX_ROLLBACK_ERR, (Throwable)e);
        }
    }

    private static Throwable tryToCopyExceptionWithCause(ExecutionException exception) {
        Throwable copy = ExceptionUtils.copyExceptionWithCause((ExecutionException)exception);
        if (copy == null) {
            return new TransactionException(ErrorGroups.Common.INTERNAL_ERR, "Cannot make a proper copy of " + exception.getCause().getClass(), (Throwable)exception);
        }
        return copy;
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public boolean isRolledBackWithTimeoutExceeded() {
        return this.timeoutExceeded;
    }
}

