/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.replicator.PartitionGroupId;
import org.apache.ignite.internal.replicator.ReplicationGroupId;
import org.apache.ignite.internal.replicator.TablePartitionId;
import org.apache.ignite.internal.replicator.ZonePartitionId;
import org.apache.ignite.internal.tx.TxMeta;
import org.apache.ignite.internal.tx.TxState;
import org.apache.ignite.internal.tx.impl.EnlistedPartitionGroup;
import org.apache.ignite.internal.util.io.IgniteDataInput;
import org.apache.ignite.internal.util.io.IgniteDataOutput;
import org.apache.ignite.internal.versioned.VersionedSerializer;

public class TxMetaSerializer
extends VersionedSerializer<TxMeta> {
    public static final TxMetaSerializer INSTANCE = new TxMetaSerializer();

    protected byte getProtocolVersion() {
        return 2;
    }

    protected void writeExternalData(TxMeta meta, IgniteDataOutput out) throws IOException {
        boolean hasAnyZonePartitionIds = TxMetaSerializer.hasAnyZonePartitionIds(meta);
        if (hasAnyZonePartitionIds) assert (TxMetaSerializer.hasNoTablePartitionIds(meta)) : "Both table-based and zone-based partition IDs: " + meta.enlistedPartitions();
        out.writeBoolean(hasAnyZonePartitionIds);
        out.writeVarInt((long)meta.txState().id());
        out.writeVarInt((long)meta.enlistedPartitions().size());
        for (EnlistedPartitionGroup enlistedPartitionGroup : meta.enlistedPartitions()) {
            PartitionGroupId partitionGroupId = (PartitionGroupId)enlistedPartitionGroup.groupId();
            out.writeVarInt((long)partitionGroupId.objectId());
            out.writeVarInt((long)partitionGroupId.partitionId());
            TxMetaSerializer.writeVarIntSet(enlistedPartitionGroup.tableIds(), (IgniteDataOutput)out);
        }
        HybridTimestamp.write((HybridTimestamp)meta.commitTimestamp(), (IgniteDataOutput)out);
    }

    private static boolean hasAnyZonePartitionIds(TxMeta meta) {
        return meta.enlistedPartitions().stream().anyMatch(partition -> partition.groupId() instanceof ZonePartitionId);
    }

    private static boolean hasNoTablePartitionIds(TxMeta meta) {
        return meta.enlistedPartitions().stream().noneMatch(partition -> partition.groupId() instanceof TablePartitionId);
    }

    protected TxMeta readExternalData(byte protoVer, IgniteDataInput in) throws IOException {
        boolean usesZonePartitionIds = protoVer >= 2 ? in.readBoolean() : false;
        TxState state = TxState.fromId(in.readVarIntAsInt());
        List<EnlistedPartitionGroup> enlistedPartitions = TxMetaSerializer.readEnlistedPartitions(in, protoVer, usesZonePartitionIds);
        HybridTimestamp commitTimestamp = HybridTimestamp.readNullableFrom((IgniteDataInput)in);
        return new TxMeta(state, enlistedPartitions, commitTimestamp);
    }

    private static List<EnlistedPartitionGroup> readEnlistedPartitions(IgniteDataInput in, byte protoVer, boolean usesZonePartitionIds) throws IOException {
        int length = in.readVarIntAsInt();
        ArrayList<EnlistedPartitionGroup> enlistedPartitions = new ArrayList<EnlistedPartitionGroup>(length);
        for (int i = 0; i < length; ++i) {
            int objectId = in.readVarIntAsInt();
            int partitionId = in.readVarIntAsInt();
            Set<Integer> tableIds = protoVer >= 2 ? TxMetaSerializer.readVarIntSet((IgniteDataInput)in) : Set.of(Integer.valueOf(objectId));
            enlistedPartitions.add(new EnlistedPartitionGroup(TxMetaSerializer.replicationGroupId(objectId, partitionId, usesZonePartitionIds), tableIds));
        }
        return enlistedPartitions;
    }

    private static ReplicationGroupId replicationGroupId(int objectId, int partitionId, boolean usesZonePartitionIds) {
        if (usesZonePartitionIds) {
            return new ZonePartitionId(objectId, partitionId);
        }
        return new TablePartitionId(objectId, partitionId);
    }
}

