/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.message;

import org.apache.ignite.internal.network.NetworkMessage;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.MessageWriter;
import org.apache.ignite.internal.tx.message.TxMessagesTypeInfos;
import org.apache.ignite.internal.tx.message.TxStateResponse;
import org.apache.ignite.internal.tx.message.TxStateResponseImpl;

class TxStateResponseSerializer
implements MessageSerializer<TxStateResponse> {
    public static final TxStateResponseSerializer INSTANCE = new TxStateResponseSerializer();

    private TxStateResponseSerializer() {
    }

    public boolean writeMessage(TxStateResponse msg, MessageWriter writer) throws MessageMappingException {
        TxStateResponseImpl message = (TxStateResponseImpl)msg;
        writer.setMessageTypeInfo(TxMessagesTypeInfos.txStateResponse());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)2)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeHybridTimestamp("timestamp", message.timestamp());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeMessage("txStateMeta", (NetworkMessage)message.txStateMeta());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

