/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.message;

import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.internal.tx.message.TxFinishResponse;
import org.apache.ignite.internal.tx.message.TxFinishResponseBuilder;
import org.apache.ignite.internal.tx.message.TxMessagesFactory;
import org.apache.ignite.internal.tx.message.TxMessagesTypeInfos;

class TxFinishResponseDeserializer
implements MessageDeserializer<TxFinishResponse> {
    private final TxFinishResponseBuilder msg;

    TxFinishResponseDeserializer(TxMessagesFactory messageFactory) {
        this.msg = messageFactory.txFinishResponse();
    }

    public Class<TxFinishResponse> klass() {
        return TxFinishResponse.class;
    }

    public TxFinishResponse getMessage() {
        return this.msg.buildDeserialized();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(TxMessagesTypeInfos.txFinishResponse());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                String tmp = reader.readString("errorMessage");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.errorMessage(tmp);
                }
                reader.incrementState();
            }
            case 1: {
                String tmp = reader.readHybridTimestamp("timestamp");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.timestamp((HybridTimestamp)tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(TxFinishResponse.class);
    }
}

