/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.configuration;

import com.google.auto.service.AutoService;
import java.util.Collection;
import java.util.List;
import org.apache.ignite.configuration.ConfigurationModule;
import org.apache.ignite.configuration.SuperRootChange;
import org.apache.ignite.configuration.annotation.ConfigurationType;
import org.apache.ignite.internal.tx.configuration.TransactionConfigurationSchema;
import org.apache.ignite.internal.tx.configuration.TransactionExtensionChange;
import org.apache.ignite.internal.tx.configuration.TransactionExtensionConfiguration;
import org.apache.ignite.internal.tx.configuration.TransactionExtensionConfigurationSchema;
import org.apache.ignite.internal.tx.configuration.TransactionExtensionView;

@AutoService(value={ConfigurationModule.class})
public class TransactionConfigurationModule
implements ConfigurationModule {
    public ConfigurationType type() {
        return ConfigurationType.DISTRIBUTED;
    }

    public Collection<Class<?>> schemaExtensions() {
        return List.of(TransactionExtensionConfigurationSchema.class);
    }

    public void migrateDeprecatedConfigurations(SuperRootChange superRootChange) {
        TransactionExtensionChange rootChange;
        TransactionExtensionView rootView = (TransactionExtensionView)superRootChange.viewRoot(TransactionExtensionConfiguration.KEY);
        if (rootView.transaction().readOnlyTimeoutMillis() != TransactionConfigurationSchema.DEFAULT_RO_TIMEOUT_MILLIS) {
            rootChange = (TransactionExtensionChange)superRootChange.changeRoot(TransactionExtensionConfiguration.KEY);
            rootChange.changeTransaction().changeReadOnlyTimeoutMillis(rootView.transaction().readOnlyTimeoutMillis());
        }
        if (rootView.transaction().readWriteTimeoutMillis() != TransactionConfigurationSchema.DEFAULT_RW_TIMEOUT_MILLIS) {
            rootChange = (TransactionExtensionChange)superRootChange.changeRoot(TransactionExtensionConfiguration.KEY);
            rootChange.changeTransaction().changeReadWriteTimeoutMillis(rootView.transaction().readWriteTimeoutMillis());
        }
    }
}

