/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx;

import java.util.UUID;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.replicator.ReplicationGroupId;
import org.apache.ignite.internal.replicator.message.ReplicaMessageUtils;
import org.apache.ignite.internal.replicator.message.ReplicaMessagesFactory;
import org.apache.ignite.internal.tostring.IgniteToStringExclude;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.tx.InternalTransaction;
import org.apache.ignite.internal.tx.TransactionMeta;
import org.apache.ignite.internal.tx.TxState;
import org.apache.ignite.internal.tx.TxStateMetaAbandoned;
import org.apache.ignite.internal.tx.TxStateMetaFinishing;
import org.apache.ignite.internal.tx.message.TxMessagesFactory;
import org.apache.ignite.internal.tx.message.TxStateMetaMessage;
import org.apache.ignite.internal.util.FastTimestamps;
import org.jetbrains.annotations.Nullable;

public class TxStateMeta
implements TransactionMeta {
    private static final long serialVersionUID = 8521181896862227127L;
    private final TxState txState;
    @Nullable
    private final UUID txCoordinatorId;
    @Nullable
    private final ReplicationGroupId commitPartitionId;
    @Nullable
    private final HybridTimestamp commitTimestamp;
    @Nullable
    private final Long initialVacuumObservationTimestamp;
    @Nullable
    private final Long cleanupCompletionTimestamp;
    @Nullable
    private final Boolean isFinishedDueToTimeout;
    @IgniteToStringExclude
    @Nullable
    private final InternalTransaction tx;

    public TxStateMeta(TxState txState, @Nullable UUID txCoordinatorId, @Nullable ReplicationGroupId commitPartitionId, @Nullable HybridTimestamp commitTimestamp, @Nullable InternalTransaction tx, @Nullable Boolean isFinishedDueToTimeout) {
        this(txState, txCoordinatorId, commitPartitionId, commitTimestamp, tx, null, isFinishedDueToTimeout);
    }

    public TxStateMeta(TxState txState, @Nullable UUID txCoordinatorId, @Nullable ReplicationGroupId commitPartitionId, @Nullable HybridTimestamp commitTimestamp, @Nullable InternalTransaction tx, @Nullable Long initialVacuumObservationTimestamp, @Nullable Boolean isFinishedDueToTimeout) {
        this(txState, txCoordinatorId, commitPartitionId, commitTimestamp, tx, initialVacuumObservationTimestamp, null, isFinishedDueToTimeout);
    }

    public TxStateMeta(TxState txState, @Nullable UUID txCoordinatorId, @Nullable ReplicationGroupId commitPartitionId, @Nullable HybridTimestamp commitTimestamp, @Nullable InternalTransaction tx, @Nullable Long initialVacuumObservationTimestamp, @Nullable Long cleanupCompletionTimestamp, @Nullable Boolean isFinishedDueToTimeout) {
        this.txState = txState;
        this.txCoordinatorId = txCoordinatorId;
        this.commitPartitionId = commitPartitionId;
        this.commitTimestamp = commitTimestamp;
        this.tx = tx;
        this.cleanupCompletionTimestamp = cleanupCompletionTimestamp;
        this.isFinishedDueToTimeout = isFinishedDueToTimeout;
        this.initialVacuumObservationTimestamp = initialVacuumObservationTimestamp != null ? initialVacuumObservationTimestamp : (TxState.isFinalState(txState) ? Long.valueOf(FastTimestamps.coarseCurrentTimeMillis()) : null);
    }

    @Nullable
    public InternalTransaction tx() {
        return this.tx;
    }

    public TxStateMetaAbandoned abandoned() {
        assert (TxState.checkTransitionCorrectness(this.txState, TxState.ABANDONED)) : "Transaction state is incorrect [txState=" + this.txState + "].";
        return new TxStateMetaAbandoned(this.txCoordinatorId, this.commitPartitionId);
    }

    public TxStateMetaFinishing finishing(boolean isFinishedDueToTimeoutFlag) {
        return new TxStateMetaFinishing(this.txCoordinatorId, this.commitPartitionId, isFinishedDueToTimeoutFlag);
    }

    @Override
    public TxState txState() {
        return this.txState;
    }

    @Nullable
    public UUID txCoordinatorId() {
        return this.txCoordinatorId;
    }

    @Nullable
    public ReplicationGroupId commitPartitionId() {
        return this.commitPartitionId;
    }

    @Override
    @Nullable
    public HybridTimestamp commitTimestamp() {
        return this.commitTimestamp;
    }

    @Nullable
    public Long initialVacuumObservationTimestamp() {
        return this.initialVacuumObservationTimestamp;
    }

    @Nullable
    public Long cleanupCompletionTimestamp() {
        return this.cleanupCompletionTimestamp;
    }

    @Nullable
    public Boolean isFinishedDueToTimeout() {
        return this.isFinishedDueToTimeout;
    }

    @Override
    public TxStateMetaMessage toTransactionMetaMessage(ReplicaMessagesFactory replicaMessagesFactory, TxMessagesFactory txMessagesFactory) {
        return txMessagesFactory.txStateMetaMessage().txState(this.txState).txCoordinatorId(this.txCoordinatorId).commitPartitionId(this.commitPartitionId == null ? null : ReplicaMessageUtils.toReplicationGroupIdMessage((ReplicaMessagesFactory)replicaMessagesFactory, (ReplicationGroupId)this.commitPartitionId)).commitTimestamp(this.commitTimestamp).initialVacuumObservationTimestamp(this.initialVacuumObservationTimestamp).cleanupCompletionTimestamp(this.cleanupCompletionTimestamp).isFinishedDueToTimeout(this.isFinishedDueToTimeout).build();
    }

    public String toString() {
        return S.toString(TxStateMeta.class, (Object)this);
    }
}

