/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.message;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.tx.message.TransactionMetaMessage;
import org.apache.ignite.internal.tx.message.TxStateResponse;
import org.apache.ignite.internal.tx.message.TxStateResponseBuilder;
import org.apache.ignite.internal.tx.message.TxStateResponseSerializer;

public class TxStateResponseImpl
implements TxStateResponse,
Cloneable {
    public static final short GROUP_TYPE = 5;
    public static final short TYPE = 5;
    @IgniteToStringInclude
    private final HybridTimestamp timestamp;
    @IgniteToStringInclude
    private final TransactionMetaMessage txStateMeta;

    private TxStateResponseImpl(HybridTimestamp timestamp, TransactionMetaMessage txStateMeta) {
        this.timestamp = timestamp;
        this.txStateMeta = txStateMeta;
    }

    public HybridTimestamp timestamp() {
        return this.timestamp;
    }

    @Override
    public TransactionMetaMessage txStateMeta() {
        return this.txStateMeta;
    }

    public MessageSerializer serializer() {
        return TxStateResponseSerializer.INSTANCE;
    }

    public short groupType() {
        return 5;
    }

    public String toString() {
        return S.toString(TxStateResponseImpl.class, (Object)this);
    }

    public short messageType() {
        return 5;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TxStateResponseImpl otherMessage = (TxStateResponseImpl)other;
        return Objects.equals(this.timestamp, otherMessage.timestamp) && Objects.equals(this.txStateMeta, otherMessage.txStateMeta);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.timestamp, this.txStateMeta);
        return result;
    }

    public TxStateResponseImpl clone() {
        try {
            return (TxStateResponseImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static TxStateResponseBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.txStateMeta != null) {
            this.txStateMeta.prepareMarshal(usedDescriptors, marshaller);
        }
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.txStateMeta != null) {
            this.txStateMeta.unmarshal(marshaller, descriptorsObj);
        }
    }

    private static class Builder
    implements TxStateResponseBuilder {
        private HybridTimestamp timestamp;
        private TransactionMetaMessage txStateMeta;

        private Builder() {
        }

        @Override
        public TxStateResponseBuilder timestamp(HybridTimestamp timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public TxStateResponseBuilder txStateMeta(TransactionMetaMessage txStateMeta) {
            this.txStateMeta = txStateMeta;
            return this;
        }

        @Override
        public HybridTimestamp timestamp() {
            return this.timestamp;
        }

        @Override
        public TransactionMetaMessage txStateMeta() {
            return this.txStateMeta;
        }

        @Override
        public TxStateResponse build() {
            return new TxStateResponseImpl(this.timestamp, this.txStateMeta);
        }

        @Override
        public TxStateResponse buildDeserialized() {
            return new TxStateResponseImpl(this.timestamp, this.txStateMeta);
        }
    }
}

