/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.message;

import java.util.Objects;
import java.util.Set;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.tx.message.PartitionEnlistmentMessage;
import org.apache.ignite.internal.tx.message.PartitionEnlistmentMessageBuilder;
import org.apache.ignite.internal.tx.message.PartitionEnlistmentMessageSerializer;

public class PartitionEnlistmentMessageImpl
implements PartitionEnlistmentMessage,
Cloneable {
    public static final short GROUP_TYPE = 5;
    public static final short TYPE = 19;
    @IgniteToStringInclude
    private final String primaryConsistentId;
    @IgniteToStringInclude
    private final Set<Integer> tableIds;

    private PartitionEnlistmentMessageImpl(String primaryConsistentId, Set<Integer> tableIds) {
        this.primaryConsistentId = primaryConsistentId;
        this.tableIds = tableIds;
    }

    @Override
    public String primaryConsistentId() {
        return this.primaryConsistentId;
    }

    @Override
    public Set<Integer> tableIds() {
        return this.tableIds;
    }

    public MessageSerializer serializer() {
        return PartitionEnlistmentMessageSerializer.INSTANCE;
    }

    public short groupType() {
        return 5;
    }

    public String toString() {
        return S.toString(PartitionEnlistmentMessageImpl.class, (Object)this);
    }

    public short messageType() {
        return 19;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        PartitionEnlistmentMessageImpl otherMessage = (PartitionEnlistmentMessageImpl)other;
        return Objects.equals(this.primaryConsistentId, otherMessage.primaryConsistentId) && Objects.equals(this.tableIds, otherMessage.tableIds);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.primaryConsistentId, this.tableIds);
        return result;
    }

    public PartitionEnlistmentMessageImpl clone() {
        try {
            return (PartitionEnlistmentMessageImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static PartitionEnlistmentMessageBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements PartitionEnlistmentMessageBuilder {
        private String primaryConsistentId;
        private Set<Integer> tableIds;

        private Builder() {
        }

        @Override
        public PartitionEnlistmentMessageBuilder primaryConsistentId(String primaryConsistentId) {
            Objects.requireNonNull(primaryConsistentId, "primaryConsistentId is not marked @Nullable");
            this.primaryConsistentId = primaryConsistentId;
            return this;
        }

        @Override
        public PartitionEnlistmentMessageBuilder tableIds(Set<Integer> tableIds) {
            Objects.requireNonNull(tableIds, "tableIds is not marked @Nullable");
            this.tableIds = tableIds;
            return this;
        }

        @Override
        public String primaryConsistentId() {
            return this.primaryConsistentId;
        }

        @Override
        public Set<Integer> tableIds() {
            return this.tableIds;
        }

        @Override
        public PartitionEnlistmentMessage build() {
            return new PartitionEnlistmentMessageImpl(Objects.requireNonNull(this.primaryConsistentId, "primaryConsistentId is not marked @Nullable"), Objects.requireNonNull(this.tableIds, "tableIds is not marked @Nullable"));
        }

        @Override
        public PartitionEnlistmentMessage buildDeserialized() {
            return new PartitionEnlistmentMessageImpl(this.primaryConsistentId, this.tableIds);
        }
    }
}

