/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.message;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.replicator.message.ReplicationGroupIdMessage;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.tx.TxState;
import org.apache.ignite.internal.tx.message.TxStateMetaFinishingMessage;
import org.apache.ignite.internal.tx.message.TxStateMetaFinishingMessageBuilder;
import org.apache.ignite.internal.tx.message.TxStateMetaFinishingMessageSerializer;

public class TxStateMetaFinishingMessageImpl
implements TxStateMetaFinishingMessage,
Cloneable {
    public static final short GROUP_TYPE = 5;
    public static final short TYPE = 17;
    @IgniteToStringInclude
    private final Long cleanupCompletionTimestamp;
    @IgniteToStringInclude
    private final ReplicationGroupIdMessage commitPartitionId;
    @IgniteToStringInclude
    private final HybridTimestamp commitTimestamp;
    @IgniteToStringInclude
    private final Long initialVacuumObservationTimestamp;
    @IgniteToStringInclude
    private final Boolean isFinishedDueToTimeout;
    @IgniteToStringInclude
    private final UUID txCoordinatorId;
    @IgniteToStringInclude
    private final TxState txState;

    private TxStateMetaFinishingMessageImpl(Long cleanupCompletionTimestamp, ReplicationGroupIdMessage commitPartitionId, HybridTimestamp commitTimestamp, Long initialVacuumObservationTimestamp, Boolean isFinishedDueToTimeout, UUID txCoordinatorId, TxState txState) {
        this.cleanupCompletionTimestamp = cleanupCompletionTimestamp;
        this.commitPartitionId = commitPartitionId;
        this.commitTimestamp = commitTimestamp;
        this.initialVacuumObservationTimestamp = initialVacuumObservationTimestamp;
        this.isFinishedDueToTimeout = isFinishedDueToTimeout;
        this.txCoordinatorId = txCoordinatorId;
        this.txState = txState;
    }

    @Override
    public Long cleanupCompletionTimestamp() {
        return this.cleanupCompletionTimestamp;
    }

    @Override
    public ReplicationGroupIdMessage commitPartitionId() {
        return this.commitPartitionId;
    }

    @Override
    public HybridTimestamp commitTimestamp() {
        return this.commitTimestamp;
    }

    @Override
    public Long initialVacuumObservationTimestamp() {
        return this.initialVacuumObservationTimestamp;
    }

    @Override
    public Boolean isFinishedDueToTimeout() {
        return this.isFinishedDueToTimeout;
    }

    @Override
    public UUID txCoordinatorId() {
        return this.txCoordinatorId;
    }

    @Override
    public TxState txState() {
        return this.txState;
    }

    public MessageSerializer serializer() {
        return TxStateMetaFinishingMessageSerializer.INSTANCE;
    }

    public short groupType() {
        return 5;
    }

    public String toString() {
        return S.toString(TxStateMetaFinishingMessageImpl.class, (Object)this);
    }

    public short messageType() {
        return 17;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TxStateMetaFinishingMessageImpl otherMessage = (TxStateMetaFinishingMessageImpl)other;
        return Objects.equals(this.cleanupCompletionTimestamp, otherMessage.cleanupCompletionTimestamp) && Objects.equals(this.commitPartitionId, otherMessage.commitPartitionId) && Objects.equals(this.commitTimestamp, otherMessage.commitTimestamp) && Objects.equals(this.initialVacuumObservationTimestamp, otherMessage.initialVacuumObservationTimestamp) && Objects.equals(this.isFinishedDueToTimeout, otherMessage.isFinishedDueToTimeout) && Objects.equals(this.txCoordinatorId, otherMessage.txCoordinatorId) && Objects.equals((Object)this.txState, (Object)otherMessage.txState);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(new Object[]{this.cleanupCompletionTimestamp, this.commitPartitionId, this.commitTimestamp, this.initialVacuumObservationTimestamp, this.isFinishedDueToTimeout, this.txCoordinatorId, this.txState});
        return result;
    }

    public TxStateMetaFinishingMessageImpl clone() {
        try {
            return (TxStateMetaFinishingMessageImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static TxStateMetaFinishingMessageBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.commitPartitionId != null) {
            this.commitPartitionId.prepareMarshal(usedDescriptors, (Object)marshaller);
        }
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.commitPartitionId != null) {
            this.commitPartitionId.unmarshal((Object)marshaller, descriptorsObj);
        }
    }

    private static class Builder
    implements TxStateMetaFinishingMessageBuilder {
        private Long cleanupCompletionTimestamp;
        private ReplicationGroupIdMessage commitPartitionId;
        private HybridTimestamp commitTimestamp;
        private Long initialVacuumObservationTimestamp;
        private Boolean isFinishedDueToTimeout;
        private UUID txCoordinatorId;
        private TxState txState;

        private Builder() {
        }

        @Override
        public TxStateMetaFinishingMessageBuilder cleanupCompletionTimestamp(Long cleanupCompletionTimestamp) {
            this.cleanupCompletionTimestamp = cleanupCompletionTimestamp;
            return this;
        }

        @Override
        public TxStateMetaFinishingMessageBuilder commitPartitionId(ReplicationGroupIdMessage commitPartitionId) {
            this.commitPartitionId = commitPartitionId;
            return this;
        }

        @Override
        public TxStateMetaFinishingMessageBuilder commitTimestamp(HybridTimestamp commitTimestamp) {
            this.commitTimestamp = commitTimestamp;
            return this;
        }

        @Override
        public TxStateMetaFinishingMessageBuilder initialVacuumObservationTimestamp(Long initialVacuumObservationTimestamp) {
            this.initialVacuumObservationTimestamp = initialVacuumObservationTimestamp;
            return this;
        }

        @Override
        public TxStateMetaFinishingMessageBuilder isFinishedDueToTimeout(Boolean isFinishedDueToTimeout) {
            this.isFinishedDueToTimeout = isFinishedDueToTimeout;
            return this;
        }

        @Override
        public TxStateMetaFinishingMessageBuilder txCoordinatorId(UUID txCoordinatorId) {
            this.txCoordinatorId = txCoordinatorId;
            return this;
        }

        @Override
        public TxStateMetaFinishingMessageBuilder txState(TxState txState) {
            Objects.requireNonNull(txState, "txState is not marked @Nullable");
            this.txState = txState;
            return this;
        }

        @Override
        public Long cleanupCompletionTimestamp() {
            return this.cleanupCompletionTimestamp;
        }

        @Override
        public ReplicationGroupIdMessage commitPartitionId() {
            return this.commitPartitionId;
        }

        @Override
        public HybridTimestamp commitTimestamp() {
            return this.commitTimestamp;
        }

        @Override
        public Long initialVacuumObservationTimestamp() {
            return this.initialVacuumObservationTimestamp;
        }

        @Override
        public Boolean isFinishedDueToTimeout() {
            return this.isFinishedDueToTimeout;
        }

        @Override
        public UUID txCoordinatorId() {
            return this.txCoordinatorId;
        }

        @Override
        public TxState txState() {
            return this.txState;
        }

        @Override
        public TxStateMetaFinishingMessage build() {
            return new TxStateMetaFinishingMessageImpl(this.cleanupCompletionTimestamp, this.commitPartitionId, this.commitTimestamp, this.initialVacuumObservationTimestamp, this.isFinishedDueToTimeout, this.txCoordinatorId, Objects.requireNonNull(this.txState, "txState is not marked @Nullable"));
        }

        @Override
        public TxStateMetaFinishingMessage buildDeserialized() {
            return new TxStateMetaFinishingMessageImpl(this.cleanupCompletionTimestamp, this.commitPartitionId, this.commitTimestamp, this.initialVacuumObservationTimestamp, this.isFinishedDueToTimeout, this.txCoordinatorId, this.txState);
        }
    }
}

