/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.views;

import java.time.Instant;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Flow;
import java.util.stream.Stream;
import org.apache.ignite.internal.systemview.api.NodeSystemView;
import org.apache.ignite.internal.systemview.api.SystemView;
import org.apache.ignite.internal.systemview.api.SystemViews;
import org.apache.ignite.internal.tx.InternalTransaction;
import org.apache.ignite.internal.tx.TransactionIds;
import org.apache.ignite.internal.tx.TxState;
import org.apache.ignite.internal.tx.TxStateMeta;
import org.apache.ignite.internal.type.NativeType;
import org.apache.ignite.internal.type.NativeTypes;
import org.apache.ignite.internal.util.SubscriptionUtils;
import org.jetbrains.annotations.Nullable;

public class TransactionsViewProvider {
    public static final String READ_ONLY = "READ_ONLY";
    public static final String READ_WRITE = "READ_WRITE";
    public static final String CACHE = "CACHE";
    private volatile TxInfoDataSource dataSource;

    public void init(UUID localNodeId, Map<UUID, TxStateMeta> txStates) {
        this.dataSource = new TxInfoDataSource(localNodeId, txStates);
    }

    public SystemView<?> get() {
        Flow.Publisher dataProvider = SubscriptionUtils.fromIterable(() -> {
            TxInfoDataSource dataSource0 = this.dataSource;
            return dataSource0 == null ? Collections.emptyIterator() : dataSource0.iterator();
        });
        NativeType stringType = NativeTypes.stringOf((int)64);
        NativeType timestampType = NativeTypes.timestamp((int)9);
        return ((NodeSystemView.Builder)((NodeSystemView.Builder)((NodeSystemView.Builder)((NodeSystemView.Builder)((NodeSystemView.Builder)((NodeSystemView.Builder)((NodeSystemView.Builder)((NodeSystemView.Builder)((NodeSystemView.Builder)((NodeSystemView.Builder)((NodeSystemView.Builder)((NodeSystemView.Builder)SystemViews.nodeViewBuilder().name("TRANSACTIONS")).nodeNameColumnAlias("COORDINATOR_NODE_ID").addColumn("TRANSACTION_STATE", stringType, tx -> tx.state)).addColumn("TRANSACTION_ID", stringType, tx -> tx.id)).addColumn("TRANSACTION_START_TIME", timestampType, tx -> tx.startTime)).addColumn("TRANSACTION_TYPE", stringType, tx -> tx.type)).addColumn("TRANSACTION_PRIORITY", stringType, tx -> tx.priority)).addColumn("STATE", stringType, tx -> tx.state)).addColumn("ID", stringType, tx -> tx.id)).addColumn("START_TIME", timestampType, tx -> tx.startTime)).addColumn("TYPE", stringType, tx -> tx.type)).addColumn("PRIORITY", stringType, tx -> tx.priority)).dataProvider(dataProvider)).build();
    }

    static class TxInfoDataSource
    implements Iterable<TxInfo> {
        private final UUID localNodeId;
        private final Map<UUID, TxStateMeta> txStates;

        TxInfoDataSource(UUID localNodeId, Map<UUID, TxStateMeta> txStates) {
            this.localNodeId = localNodeId;
            this.txStates = txStates;
        }

        @Override
        public Iterator<TxInfo> iterator() {
            return this.txStates.entrySet().stream().flatMap(entry -> {
                UUID id = (UUID)entry.getKey();
                TxStateMeta txStateMeta = (TxStateMeta)entry.getValue();
                UUID coordinatorId = txStateMeta.txCoordinatorId();
                InternalTransaction tx = txStateMeta.tx();
                if (!Objects.equals(this.localNodeId, coordinatorId)) {
                    return Stream.empty();
                }
                if (tx != null && tx.isReadOnly() && tx.isFinishingOrFinished() || TxState.isFinalState(txStateMeta.txState())) {
                    return Stream.empty();
                }
                return Stream.of(new TxInfo(id, txStateMeta.txState(), TxInfoDataSource.deriveTransactionType(tx)));
            }).iterator();
        }

        private static String deriveTransactionType(@Nullable InternalTransaction tx) {
            if (tx != null) {
                return tx.isReadOnly() ? TransactionsViewProvider.READ_ONLY : TransactionsViewProvider.READ_WRITE;
            }
            return "n/a";
        }
    }

    static class TxInfo {
        private final String id;
        private final String state;
        private final Instant startTime;
        private final String type;
        private final String priority;

        TxInfo(UUID txId, TxState txState, String type) {
            this.id = txId.toString();
            this.state = txState.name();
            this.startTime = Instant.ofEpochMilli(TransactionIds.beginTimestamp(txId).getPhysical());
            this.type = type;
            this.priority = TransactionIds.priority(txId).name();
        }
    }
}

