/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.message;

import org.apache.ignite.internal.network.NetworkMessage;
import org.apache.ignite.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.MessageWriter;
import org.apache.ignite.internal.tx.message.EnlistedPartitionGroupMessage;
import org.apache.ignite.internal.tx.message.EnlistedPartitionGroupMessageImpl;
import org.apache.ignite.internal.tx.message.TxMessagesTypeInfos;

class EnlistedPartitionGroupMessageSerializer
implements MessageSerializer<EnlistedPartitionGroupMessage> {
    public static final EnlistedPartitionGroupMessageSerializer INSTANCE = new EnlistedPartitionGroupMessageSerializer();

    private EnlistedPartitionGroupMessageSerializer() {
    }

    public boolean writeMessage(EnlistedPartitionGroupMessage msg, MessageWriter writer) throws MessageMappingException {
        EnlistedPartitionGroupMessageImpl message = (EnlistedPartitionGroupMessageImpl)msg;
        writer.setMessageTypeInfo(TxMessagesTypeInfos.enlistedPartitionGroupMessage());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)2)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeMessage("groupId", (NetworkMessage)message.groupId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeSet("tableIds", message.tableIds(), MessageCollectionItemType.INT);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

