/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.message;

import java.util.Set;
import org.apache.ignite.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.internal.replicator.message.ReplicationGroupIdMessage;
import org.apache.ignite.internal.tx.message.EnlistedPartitionGroupMessage;
import org.apache.ignite.internal.tx.message.EnlistedPartitionGroupMessageBuilder;
import org.apache.ignite.internal.tx.message.TxMessagesFactory;
import org.apache.ignite.internal.tx.message.TxMessagesTypeInfos;

class EnlistedPartitionGroupMessageDeserializer
implements MessageDeserializer<EnlistedPartitionGroupMessage> {
    private final EnlistedPartitionGroupMessageBuilder msg;

    EnlistedPartitionGroupMessageDeserializer(TxMessagesFactory messageFactory) {
        this.msg = messageFactory.enlistedPartitionGroupMessage();
    }

    public Class<EnlistedPartitionGroupMessage> klass() {
        return EnlistedPartitionGroupMessage.class;
    }

    public EnlistedPartitionGroupMessage getMessage() {
        return this.msg.buildDeserialized();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(TxMessagesTypeInfos.enlistedPartitionGroupMessage());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                Object tmp = (ReplicationGroupIdMessage)reader.readMessage("groupId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.groupId((ReplicationGroupIdMessage)tmp);
                }
                reader.incrementState();
            }
            case 1: {
                Object tmp = reader.readSet("tableIds", MessageCollectionItemType.INT);
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.tableIds((Set<Integer>)tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(EnlistedPartitionGroupMessage.class);
    }
}

