/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.tools.rat;

import java.util.regex.Pattern;
import org.apache.rat.analysis.RatHeaderAnalysisException;
import org.apache.rat.analysis.license.FullTextMatchingLicense;
import org.apache.rat.api.Document;
import org.apache.rat.api.MetaData;

public class GridGainLicense
extends FullTextMatchingLicense {
    private Pattern copyrightPtrn;
    private boolean copyrightMatch;

    public GridGainLicense() {
        super(MetaData.RAT_LICENSE_FAMILY_CATEGORY_DATUM_ASL, new MetaData.Datum("http://org/apache/rat/meta-data#LicenseFamilyName", "Ignite Apache License 2.0"), "No modifications allowed", "");
    }

    public void setCopyright(String copyright) {
        this.copyrightPtrn = Pattern.compile(copyright);
    }

    public boolean match(Document subject, String line) throws RatHeaderAnalysisException {
        if (this.copyrightPtrn == null) {
            return super.match(subject, line);
        }
        boolean res = false;
        if (this.copyrightMatch) {
            res = super.match(subject, line);
        } else {
            this.copyrightMatch = this.copyrightPtrn.matcher(line).matches();
        }
        return res;
    }

    public void reset() {
        this.copyrightMatch = false;
        super.reset();
    }
}

