/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.tools.junit;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.ignite.tools.junit.X;
import org.junit.Ignore;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class JUnitTeamcityReporter
extends RunListener {
    private static final long FLUSH_THRESHOLD = 300000L;
    public static volatile String suite;
    private final Path reportDir = Files.createTempDirectory("ignite-tools-junit-reports", new FileAttribute[0]);
    private final XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
    private String prevSuite;
    private String prevTestCls;
    private long prevFlush;
    private FileOutputStream curStream;
    private XMLStreamWriter curXmlStream;

    public synchronized void testAssumptionFailure(Failure failure) {
        if (this.curXmlStream == null) {
            this.testStarted(failure.getDescription());
        }
        try {
            this.curXmlStream.writeStartElement("skipped");
            if (failure.getMessage() != null) {
                this.curXmlStream.writeAttribute("message", failure.getMessage());
            }
            this.curXmlStream.writeEndElement();
        }
        catch (XMLStreamException ex) {
            throw new RuntimeException(ex);
        }
    }

    public synchronized void testStarted(Description desc) {
        if (!desc.getClassName().equals(this.prevTestCls)) {
            System.out.println(String.format("##teamcity[progressMessage 'Running %s']", this.escapeForTeamcity(desc.getClassName())));
        }
        try {
            if (this.afterFlush(desc.getClassName())) {
                this.prevSuite = suite;
                this.prevFlush = System.currentTimeMillis();
                this.curStream = new FileOutputStream(this.reportDir.resolve(this.fileName()).toFile());
                this.curXmlStream = this.outputFactory.createXMLStreamWriter(this.curStream);
                this.curXmlStream.writeStartDocument();
                this.curXmlStream.writeStartElement("testsuite");
                this.curXmlStream.writeAttribute("version", "3.0");
                this.curXmlStream.writeAttribute("name", suite != null ? suite : desc.getClassName());
            }
            this.prevTestCls = desc.getClassName();
            this.curXmlStream.writeStartElement("testcase");
            this.curXmlStream.writeAttribute("name", desc.getMethodName() != null ? desc.getMethodName() : "");
            this.curXmlStream.writeAttribute("classname", desc.getClassName());
            this.curXmlStream.writeAttribute("time", "0");
        }
        catch (FileNotFoundException | XMLStreamException ex) {
            throw new RuntimeException(ex);
        }
    }

    public synchronized void testFinished(Description desc) {
        if (this.curXmlStream == null) {
            this.testStarted(desc);
        }
        try {
            this.curXmlStream.writeEndElement();
        }
        catch (XMLStreamException ex) {
            throw new RuntimeException(ex);
        }
    }

    public synchronized void testFailure(Failure failure) {
        if (this.curXmlStream == null) {
            this.testStarted(failure.getDescription());
        }
        try {
            this.curXmlStream.writeStartElement("failure");
            if (failure.getException() != null && failure.getException().getMessage() != null) {
                this.curXmlStream.writeAttribute("type", failure.getException().getMessage());
            }
            if (failure.getMessage() != null) {
                this.curXmlStream.writeCData(failure.getMessage());
            }
            this.curXmlStream.writeEndElement();
            if (failure.getException() != null) {
                this.curXmlStream.writeStartElement("system-out");
                this.curXmlStream.writeCData(X.getFullStackTrace(failure.getException()));
                this.curXmlStream.writeEndElement();
            }
        }
        catch (XMLStreamException ex) {
            throw new RuntimeException(ex);
        }
    }

    public synchronized void testIgnored(Description desc) {
        this.testStarted(desc);
        Ignore annotation = (Ignore)desc.getAnnotation(Ignore.class);
        try {
            this.curXmlStream.writeStartElement("skipped");
            if (annotation != null) {
                this.curXmlStream.writeAttribute("message", annotation.value());
            }
            this.curXmlStream.writeEndElement();
        }
        catch (XMLStreamException ex) {
            throw new RuntimeException(ex);
        }
        this.testFinished(desc);
    }

    private boolean afterFlush(String testCls) {
        if (this.curStream == null) {
            return true;
        }
        if ((this.prevSuite != null ? !this.prevSuite.equals(suite) : suite != null) || (this.prevTestCls != null ? !this.prevTestCls.equals(testCls) : testCls != null) || System.currentTimeMillis() - this.prevFlush > 300000L) {
            try {
                this.curXmlStream.writeEndElement();
                this.curXmlStream.writeEndDocument();
                this.curXmlStream.close();
                this.curStream.close();
            }
            catch (IOException | XMLStreamException ex) {
                throw new RuntimeException(ex);
            }
            File report = this.reportDir.resolve(this.fileName()).toFile();
            assert (report.exists());
            System.out.println(String.format("##teamcity[importData type='surefire' path='%s']", this.escapeForTeamcity(report.getAbsolutePath())));
            return true;
        }
        return false;
    }

    private String fileName() {
        return "test-" + this.prevSuite + this.prevFlush + ".xml";
    }

    private String escapeForTeamcity(String msg) {
        return (msg == null ? "null" : msg).replace("|", "||").replace("\r", "|r").replace("\n", "|n").replace("'", "|'").replace("[", "|[").replace("]", "|]");
    }
}

