/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.tools.classgen;

import java.io.BufferedInputStream;
import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

public class ClassesGenerator {
    private static final String META_INF = "META-INF/";
    private static final String DEFAULT_FILE_PATH = "META-INF/classnames.properties";
    private static final String[] EXCLUDED_PACKAGES = new String[]{"org.apache.ignite.tools"};
    private static final URL[] EMPTY_URL_ARR = new URL[0];
    private static final Class bltClsLdrCls = ClassesGenerator.defaultClassLoaderClass();
    private static final Field urlClsLdrField = ClassesGenerator.urlClassLoaderField();
    private final Collection<Class> classes = new TreeSet<Class>(new Comparator<Class>(){

        @Override
        public int compare(Class c1, Class c2) {
            return c1.getName().compareTo(c2.getName());
        }
    });
    private final Collection<String> errs = new ArrayList<String>();
    private final String basePath;
    private final String hdr;
    private final String[] packages;
    private final String fileName;

    public static void main(String[] args) throws Exception {
        assert (args.length >= 3);
        String basePath = args[0];
        String hdr = args[1];
        String[] packages = args[2].split(":");
        String finaName = args.length == 4 ? args[3] : null;
        ClassesGenerator gen = new ClassesGenerator(basePath, hdr, packages, finaName);
        gen.generate();
    }

    private ClassesGenerator(String basePath, String hdr, String[] packages, String fileName) {
        this.basePath = basePath;
        this.hdr = hdr;
        this.packages = packages;
        this.fileName = fileName;
    }

    private void generate() throws Exception {
        System.out.println("Generating classnames.properties...");
        for (URL url : ClassesGenerator.classLoaderUrls(this.getClass().getClassLoader())) {
            this.processUrl(url);
        }
        if (!this.errs.isEmpty()) {
            StringBuilder sb = new StringBuilder("Failed to generate classnames.properties due to errors:\n");
            for (String err : this.errs) {
                sb.append("    ").append(err).append('\n');
            }
            String msg = sb.toString().trim();
            System.out.println(msg);
            throw new Exception(msg);
        }
        PrintStream out = new PrintStream(new File(this.basePath, this.fileName == null || this.fileName.isEmpty() ? DEFAULT_FILE_PATH : META_INF + this.fileName));
        out.println(this.hdr);
        out.println();
        for (Class cls : this.classes) {
            out.println(cls.getName());
        }
    }

    private void processUrl(URL url) throws Exception {
        System.out.println("    Processing URL: " + url);
        File file = new File(url.toURI());
        int prefixLen = file.getPath().length() + 1;
        this.processFile(file, prefixLen);
    }

    private void processFile(File file, int prefixLen) throws Exception {
        if (!file.exists()) {
            throw new FileNotFoundException("File doesn't exist: " + file);
        }
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                this.processFile(f, prefixLen);
            }
        } else {
            assert (file.isFile());
            String path = file.getPath();
            if (path.toLowerCase().endsWith(".jar")) {
                try (JarInputStream jin = new JarInputStream(new BufferedInputStream(new FileInputStream(path)));){
                    JarEntry entry;
                    while ((entry = jin.getNextJarEntry()) != null) {
                        if (entry.isDirectory() || !entry.getName().toLowerCase().endsWith(".class")) continue;
                        this.processClassFile(entry.getName(), 0);
                    }
                }
            } else if (path.toLowerCase().endsWith(".class")) {
                this.processClassFile(path, prefixLen);
            }
        }
    }

    public static URL[] classLoaderUrls(ClassLoader clsLdr) {
        if (clsLdr == null) {
            return EMPTY_URL_ARR;
        }
        if (clsLdr instanceof URLClassLoader) {
            return ((URLClassLoader)clsLdr).getURLs();
        }
        if (bltClsLdrCls != null && urlClsLdrField != null && bltClsLdrCls.isAssignableFrom(clsLdr.getClass())) {
            try {
                return ((URLClassLoader)urlClsLdrField.get(clsLdr)).getURLs();
            }
            catch (IllegalAccessException e) {
                return EMPTY_URL_ARR;
            }
        }
        return EMPTY_URL_ARR;
    }

    private static Class defaultClassLoaderClass() {
        try {
            return Class.forName("jdk.internal.loader.BuiltinClassLoader");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static Field urlClassLoaderField() {
        try {
            Class cls = ClassesGenerator.defaultClassLoaderClass();
            return cls == null ? null : cls.getDeclaredField("ucp");
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    private void processClassFile(String path, int prefixLen) throws Exception {
        Class<?> cls;
        String clsName = path.substring(prefixLen, path.length() - 6).replace(File.separatorChar, '.');
        for (String pkg : EXCLUDED_PACKAGES) {
            if (!clsName.startsWith(pkg)) continue;
            return;
        }
        boolean included = false;
        for (String pkg : this.packages) {
            if (!clsName.startsWith(pkg)) continue;
            included = true;
            break;
        }
        if (included && Serializable.class.isAssignableFrom(cls = Class.forName(clsName, false, this.getClass().getClassLoader())) && !cls.getName().endsWith("Future") && !cls.getName().endsWith("FutureAdapter")) {
            if (!(cls.isInterface() || Modifier.isAbstract(cls.getModifiers()) || cls.isEnum() || cls.getSimpleName().isEmpty())) {
                try {
                    int mod;
                    Field field = cls.getDeclaredField("serialVersionUID");
                    if (!field.getType().equals(Long.TYPE)) {
                        this.errs.add("serialVersionUID field is not long in class: " + cls.getName());
                    }
                    if (!Modifier.isStatic(mod = field.getModifiers())) {
                        this.errs.add("serialVersionUID field is not static in class: " + cls.getName());
                    }
                    if (!Modifier.isFinal(mod)) {
                        this.errs.add("serialVersionUID field is not final in class: " + cls.getName());
                    }
                }
                catch (NoSuchFieldException ignored) {
                    this.errs.add("No serialVersionUID field in class: " + cls.getName());
                }
                if (Externalizable.class.isAssignableFrom(cls)) {
                    try {
                        Constructor<?> cons = cls.getConstructor(new Class[0]);
                        if (!Modifier.isPublic(cons.getModifiers())) {
                            this.errs.add("Default constructor in Externalizable class is not public: " + cls.getName());
                        }
                    }
                    catch (NoSuchMethodException ignored) {
                        this.errs.add("No default constructor in Externalizable class: " + cls.getName());
                    }
                }
            }
            this.classes.add(cls);
        }
    }
}

