/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.tools.junit;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

final class X {
    public static final Object[] EMPTY_OBJECT_ARRAY;
    private static final String[] CAUSE_MTD_NAMES;
    private static final Method THROWABLE_CAUSE_METHOD;

    private X() {
    }

    private static Throwable getCauseUsingWellKnownTypes(Throwable throwable) {
        if (throwable instanceof SQLException) {
            return ((SQLException)throwable).getNextException();
        }
        if (throwable instanceof InvocationTargetException) {
            return ((InvocationTargetException)throwable).getTargetException();
        }
        return null;
    }

    private static Throwable getCauseUsingMethodName(Throwable throwable, String mtdName) {
        Method mtd = null;
        try {
            mtd = throwable.getClass().getMethod(mtdName, null);
        }
        catch (NoSuchMethodException | SecurityException exception) {
            // empty catch block
        }
        if (mtd != null && Throwable.class.isAssignableFrom(mtd.getReturnType())) {
            try {
                return (Throwable)mtd.invoke((Object)throwable, EMPTY_OBJECT_ARRAY);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static Throwable getCauseUsingFieldName(Throwable throwable, String fieldName) {
        Field field = null;
        try {
            field = throwable.getClass().getField(fieldName);
        }
        catch (NoSuchFieldException | SecurityException exception) {
            // empty catch block
        }
        if (field != null && Throwable.class.isAssignableFrom(field.getType())) {
            try {
                return (Throwable)field.get(throwable);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static boolean isThrowableNested() {
        return THROWABLE_CAUSE_METHOD != null;
    }

    private static boolean isNestedThrowable(Throwable throwable) {
        if (throwable == null) {
            return false;
        }
        if (throwable instanceof SQLException || throwable instanceof InvocationTargetException) {
            return true;
        }
        if (X.isThrowableNested()) {
            return true;
        }
        Class<?> cls = throwable.getClass();
        for (String CAUSE_MTD_NAME : CAUSE_MTD_NAMES) {
            try {
                Method mtd = cls.getMethod(CAUSE_MTD_NAME, null);
                if (mtd == null || !Throwable.class.isAssignableFrom(mtd.getReturnType())) continue;
                return true;
            }
            catch (NoSuchMethodException | SecurityException exception) {
                // empty catch block
            }
        }
        try {
            Field field = cls.getField("detail");
            if (field != null) {
                return true;
            }
        }
        catch (NoSuchFieldException | SecurityException exception) {
            // empty catch block
        }
        return false;
    }

    private static Throwable getCause(Throwable throwable) {
        return X.getCause(throwable, CAUSE_MTD_NAMES);
    }

    private static Throwable getCause(Throwable throwable, String[] mtdNames) {
        if (throwable == null) {
            return null;
        }
        Throwable cause = X.getCauseUsingWellKnownTypes(throwable);
        if (cause == null) {
            if (mtdNames == null) {
                mtdNames = CAUSE_MTD_NAMES;
            }
            for (String mtdName : mtdNames) {
                if (mtdName != null && (cause = X.getCauseUsingMethodName(throwable, mtdName)) != null) break;
            }
            if (cause == null) {
                cause = X.getCauseUsingFieldName(throwable, "detail");
            }
        }
        return cause;
    }

    private static List<Throwable> getThrowableList(Throwable throwable) {
        ArrayList<Throwable> list = new ArrayList<Throwable>();
        while (throwable != null && !list.contains(throwable)) {
            list.add(throwable);
            throwable = X.getCause(throwable);
        }
        return list;
    }

    private static Throwable[] getThrowables(Throwable throwable) {
        List<Throwable> list = X.getThrowableList(throwable);
        return list.toArray(new Throwable[list.size()]);
    }

    static String getFullStackTrace(Throwable throwable) {
        Throwable[] ts;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        for (Throwable t : ts = X.getThrowables(throwable)) {
            t.printStackTrace(pw);
            if (X.isNestedThrowable(t)) break;
        }
        return sw.getBuffer().toString();
    }

    static {
        Method causeMtd;
        EMPTY_OBJECT_ARRAY = new Object[0];
        CAUSE_MTD_NAMES = new String[]{"getCause", "getNextException", "getTargetException", "getException", "getSourceException", "getRootCause", "getCausedByException", "getNested", "getLinkedException", "getNestedException", "getLinkedCause", "getThrowable"};
        try {
            causeMtd = Throwable.class.getMethod("getCause", null);
        }
        catch (Exception ignored) {
            causeMtd = null;
        }
        THROWABLE_CAUSE_METHOD = causeMtd;
    }
}

