/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.tensorflow.submitter.command;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.ignite.Ignite;
import org.apache.ignite.tensorflow.cluster.TensorFlowClusterGatewayManager;
import org.apache.ignite.tensorflow.cluster.TensorFlowJobArchive;
import org.apache.ignite.tensorflow.submitter.command.AbstractCommand;
import picocli.CommandLine;

@CommandLine.Command(name="start", description={"Starts a new TensorFlow cluster and attaches to user script process."}, mixinStandardHelpOptions=true)
public class StartCommand
extends AbstractCommand {
    @CommandLine.Parameters(index="0", paramLabel="CACHE_NAME", description={"Upstream cache name."})
    private String cacheName;
    @CommandLine.Parameters(index="1", paramLabel="JOB_DIR", description={"Job folder (or zip archive)."})
    private String jobFolder;
    @CommandLine.Parameters(index="2", paramLabel="JOB_CMD", description={"Job command."})
    private String jobCmd;
    @CommandLine.Parameters(index="3..*", paramLabel="JOB_ARGS", description={"Job arguments."})
    private String[] jobArguments;

    @Override
    public void run() {
        try (Ignite ignite = this.getIgnite();){
            UUID clusterId = UUID.randomUUID();
            String[] commands = new String[this.jobArguments.length + 1];
            commands[0] = this.jobCmd;
            System.arraycopy(this.jobArguments, 0, commands, 1, commands.length - 1);
            TensorFlowJobArchive jobArchive = new TensorFlowJobArchive(this.cacheName, this.zip(this.jobFolder), commands);
            TensorFlowClusterGatewayManager mgr = new TensorFlowClusterGatewayManager(ignite);
            mgr.createCluster(clusterId, jobArchive);
            mgr.listenToClusterUserScript(clusterId, System.out::println, System.err::println);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] zip(String jobArchivePath) throws IOException {
        Path path = Paths.get(jobArchivePath, new String[0]);
        File file = path.toFile();
        if (!file.exists()) {
            throw new IllegalArgumentException("File doesn't exist [name=" + jobArchivePath + "]");
        }
        if (file.isDirectory()) {
            return this.zipDirectory(file);
        }
        if (jobArchivePath.endsWith(".zip")) {
            return this.zipArchive(file);
        }
        return this.zipFile(file);
    }

    private byte[] zipDirectory(File dir) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ZipOutputStream zipFile = new ZipOutputStream(baos);){
            this.compressDirectoryToZip(dir.getAbsolutePath(), dir.getAbsolutePath(), zipFile);
        }
        return baos.toByteArray();
    }

    private byte[] zipFile(File file) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ZipOutputStream zos = new ZipOutputStream(baos);){
            ZipEntry entry = new ZipEntry(file.getName());
            zos.putNextEntry(entry);
            try (FileInputStream in = new FileInputStream(file.getAbsolutePath());){
                IOUtils.copy((InputStream)in, (OutputStream)zos);
            }
        }
        return baos.toByteArray();
    }

    private byte[] zipArchive(File file) throws IOException {
        try (FileInputStream fis = new FileInputStream(file);){
            byte[] byArray = IOUtils.toByteArray((InputStream)fis);
            return byArray;
        }
    }

    private void compressDirectoryToZip(String rootDir, String srcDir, ZipOutputStream out) throws IOException {
        File[] files = new File(srcDir).listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    this.compressDirectoryToZip(rootDir, srcDir + File.separator + file.getName(), out);
                    continue;
                }
                ZipEntry entry = new ZipEntry(srcDir.replace(rootDir, "") + File.separator + file.getName());
                out.putNextEntry(entry);
                try (FileInputStream in = new FileInputStream(srcDir + File.separator + file.getName());){
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                }
            }
        }
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    public void setJobFolder(String jobFolder) {
        this.jobFolder = jobFolder;
    }

    public void setJobCmd(String jobCmd) {
        this.jobCmd = jobCmd;
    }

    public void setJobArguments(String[] jobArguments) {
        this.jobArguments = jobArguments;
    }
}

