/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.tensorflow.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Scanner;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.ignite.tensorflow.core.util.CustomizableThreadFactory;

public class NativeProcessRunner {
    private static final String NATIVE_PROCESS_FORWARD_STREAM_THREAD_NAME = "tf-forward-native-output";
    private final ProcessBuilder procBuilder;
    private final String stdin;
    private final Consumer<String> out;
    private final Consumer<String> err;

    public NativeProcessRunner(ProcessBuilder procBuilder, String stdin, Consumer<String> out, Consumer<String> err) {
        this.procBuilder = procBuilder;
        this.stdin = stdin;
        this.out = out;
        this.err = err;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startAndWait() throws InterruptedException {
        Process proc;
        try {
            proc = this.procBuilder.start();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        AtomicBoolean shutdown = new AtomicBoolean();
        Thread shutdownHook = new Thread(() -> {
            shutdown.set(true);
            proc.destroy();
        });
        Runtime.getRuntime().addShutdownHook(shutdownHook);
        Future<?> outForward = this.forwardStream(proc.getInputStream(), this.out);
        Future<?> errForward = this.forwardStream(proc.getErrorStream(), this.err);
        try {
            int status;
            if (this.stdin != null) {
                PrintWriter writer = new PrintWriter(proc.getOutputStream());
                writer.println(this.stdin);
                writer.flush();
            }
            try {
                status = proc.waitFor();
            }
            catch (InterruptedException e) {
                proc.destroy();
                throw e;
            }
            if (!shutdown.get()) {
                Runtime.getRuntime().removeShutdownHook(shutdownHook);
                if (status != 0) {
                    throw new IllegalStateException("Native process exit [status=" + status + "]");
                }
            }
        }
        finally {
            outForward.cancel(true);
            errForward.cancel(true);
        }
    }

    private Future<?> forwardStream(InputStream src, Consumer<String> dst) {
        return Executors.newSingleThreadExecutor(new CustomizableThreadFactory(NATIVE_PROCESS_FORWARD_STREAM_THREAD_NAME, true)).submit(() -> {
            Scanner scanner = new Scanner(src);
            while (!Thread.currentThread().isInterrupted() && scanner.hasNextLine()) {
                dst.accept(scanner.nextLine());
            }
        });
    }
}

