/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.tensorflow.core.util;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.tensorflow.core.util.NativeProcessRunner;

public abstract class AsyncNativeProcessRunner {
    private final IgniteLogger log;
    private final ExecutorService executor;
    private Future<?> fut;

    public AsyncNativeProcessRunner(Ignite ignite, ExecutorService executor) {
        this.log = ignite.log().getLogger(AsyncNativeProcessRunner.class);
        this.executor = executor;
    }

    public abstract NativeProcessRunner doBefore();

    public abstract void doAfter();

    public synchronized void start() {
        if (this.fut != null) {
            throw new IllegalStateException("Async native process has already been started");
        }
        NativeProcessRunner procRunner = this.doBefore();
        this.fut = this.executor.submit(() -> {
            try {
                this.log.debug("Starting native process");
                procRunner.startAndWait();
                this.log.debug("Native process completed");
            }
            catch (InterruptedException e) {
                this.log.debug("Native process interrupted");
            }
            catch (Exception e) {
                this.log.error("Native process failed", (Throwable)e);
                throw e;
            }
            finally {
                this.doAfter();
            }
        });
    }

    public synchronized void stop() {
        if (this.fut != null && !this.fut.isDone()) {
            this.fut.cancel(true);
        }
    }

    public boolean isCompleted() {
        return this.fut != null && this.fut.isDone();
    }

    public Exception getException() {
        if (!this.fut.isDone()) {
            return null;
        }
        try {
            this.fut.get();
        }
        catch (InterruptedException | ExecutionException e) {
            return e;
        }
        return null;
    }
}

