/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.tensorflow.core.longrunning.task;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import org.apache.ignite.tensorflow.core.longrunning.task.LongRunningProcessTask;
import org.apache.ignite.tensorflow.core.longrunning.task.util.LongRunningProcessState;
import org.apache.ignite.tensorflow.core.longrunning.task.util.LongRunningProcessStatus;

public class LongRunningProcessStopTask
extends LongRunningProcessTask<List<LongRunningProcessStatus>> {
    private static final long serialVersionUID = -5552468435820611170L;
    private final List<UUID> procIds;
    private final boolean clear;

    public LongRunningProcessStopTask(List<UUID> procIds, boolean clear) {
        assert (procIds != null) : "Process identifiers should not be null";
        this.procIds = procIds;
        this.clear = clear;
    }

    public List<LongRunningProcessStatus> call() {
        ArrayList<LongRunningProcessStatus> res = new ArrayList<LongRunningProcessStatus>();
        for (UUID prodId : this.procIds) {
            res.add(this.stopProcess(prodId));
        }
        if (this.clear) {
            this.removeProcessesFromMetadataStorage();
        }
        return res;
    }

    private LongRunningProcessStatus stopProcess(UUID procId) {
        ConcurrentHashMap<UUID, Future<?>> metadataStorage = this.getMetadataStorage();
        Future fut = (Future)metadataStorage.get(procId);
        if (fut == null) {
            return new LongRunningProcessStatus(LongRunningProcessState.NOT_FOUND);
        }
        try {
            fut.cancel(true);
            fut.get();
        }
        catch (Exception e) {
            return new LongRunningProcessStatus(LongRunningProcessState.DONE, e);
        }
        return new LongRunningProcessStatus(LongRunningProcessState.DONE);
    }

    private void removeProcessesFromMetadataStorage() {
        ConcurrentHashMap<UUID, Future<?>> metadataStorage = this.getMetadataStorage();
        for (UUID procId : this.procIds) {
            metadataStorage.remove(procId);
        }
    }
}

