/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.tensorflow.core.longrunning.task;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import org.apache.ignite.tensorflow.core.longrunning.task.LongRunningProcessTask;
import org.apache.ignite.tensorflow.core.longrunning.task.util.LongRunningProcessState;
import org.apache.ignite.tensorflow.core.longrunning.task.util.LongRunningProcessStatus;

public class LongRunningProcessPingTask
extends LongRunningProcessTask<List<LongRunningProcessStatus>> {
    private static final long serialVersionUID = 7003289989579770395L;
    private final List<UUID> procIds;

    public LongRunningProcessPingTask(List<UUID> procIds) {
        assert (procIds != null) : "Process identifiers should not be null";
        this.procIds = procIds;
    }

    public List<LongRunningProcessStatus> call() {
        ArrayList<LongRunningProcessStatus> statuses = new ArrayList<LongRunningProcessStatus>();
        for (UUID procId : this.procIds) {
            statuses.add(this.getProcessStatus(procId));
        }
        return statuses;
    }

    private LongRunningProcessStatus getProcessStatus(UUID procId) {
        ConcurrentHashMap<UUID, Future<?>> metadataStorage = this.getMetadataStorage();
        Future fut = (Future)metadataStorage.get(procId);
        if (fut == null) {
            return new LongRunningProcessStatus(LongRunningProcessState.NOT_FOUND);
        }
        if (!fut.isDone()) {
            return new LongRunningProcessStatus(LongRunningProcessState.RUNNING);
        }
        try {
            fut.get();
        }
        catch (Exception e) {
            return new LongRunningProcessStatus(LongRunningProcessState.DONE, e);
        }
        return new LongRunningProcessStatus(LongRunningProcessState.DONE);
    }
}

