/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.tensorflow.core.longrunning.task;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import org.apache.ignite.tensorflow.core.longrunning.task.LongRunningProcessTask;
import org.apache.ignite.tensorflow.core.longrunning.task.util.LongRunningProcessState;
import org.apache.ignite.tensorflow.core.longrunning.task.util.LongRunningProcessStatus;

public class LongRunningProcessClearTask
extends LongRunningProcessTask<List<LongRunningProcessStatus>> {
    private static final long serialVersionUID = -1840332865137076107L;
    private final List<UUID> procIds;

    public LongRunningProcessClearTask(List<UUID> procIds) {
        assert (procIds != null) : "Process identifiers should not be null";
        this.procIds = procIds;
    }

    public List<LongRunningProcessStatus> call() {
        ArrayList<LongRunningProcessStatus> res = new ArrayList<LongRunningProcessStatus>();
        for (UUID prodId : this.procIds) {
            res.add(this.prepareProcessForRemoving(prodId));
        }
        this.removeProcessesFromMetadataStorage();
        return res;
    }

    private LongRunningProcessStatus prepareProcessForRemoving(UUID procId) {
        ConcurrentHashMap<UUID, Future<?>> metadataStorage = this.getMetadataStorage();
        Future fut = (Future)metadataStorage.get(procId);
        if (fut == null) {
            return new LongRunningProcessStatus(LongRunningProcessState.NOT_FOUND);
        }
        if (!fut.isDone()) {
            throw new IllegalStateException("Process is still running [procId=" + procId + "]");
        }
        try {
            fut.get();
            return new LongRunningProcessStatus(LongRunningProcessState.DONE);
        }
        catch (Exception e) {
            return new LongRunningProcessStatus(LongRunningProcessState.DONE, e);
        }
    }

    private void removeProcessesFromMetadataStorage() {
        ConcurrentHashMap<UUID, Future<?>> metadataStorage = this.getMetadataStorage();
        for (UUID procId : this.procIds) {
            metadataStorage.remove(procId);
        }
    }
}

