/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.tensorflow.cluster.util;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.Ignition;
import org.apache.ignite.tensorflow.cluster.TensorFlowJobArchive;
import org.apache.ignite.tensorflow.cluster.spec.TensorFlowClusterSpec;
import org.apache.ignite.tensorflow.cluster.spec.TensorFlowServerAddressSpec;
import org.apache.ignite.tensorflow.cluster.util.TensorFlowProcessBuilderSupplier;
import org.apache.ignite.tensorflow.core.util.AsyncNativeProcessRunner;
import org.apache.ignite.tensorflow.core.util.NativeProcessRunner;

public class TensorFlowUserScriptRunner
extends AsyncNativeProcessRunner {
    private final IgniteLogger log;
    private final TensorFlowJobArchive jobArchive;
    private final TensorFlowClusterSpec clusterSpec;
    private final Consumer<String> out;
    private final Consumer<String> err;
    private File workingDir;

    public TensorFlowUserScriptRunner(Ignite ignite, ExecutorService executor, TensorFlowJobArchive jobArchive, TensorFlowClusterSpec clusterSpec, Consumer<String> out, Consumer<String> err) {
        super(ignite, executor);
        this.log = ignite.log().getLogger(TensorFlowUserScriptRunner.class);
        this.jobArchive = jobArchive;
        this.clusterSpec = clusterSpec;
        this.out = out;
        this.err = err;
    }

    @Override
    public NativeProcessRunner doBefore() {
        try {
            this.workingDir = Files.createTempDirectory("tf_us_", new FileAttribute[0]).toFile();
            this.log.debug("Directory has been created [path=" + this.workingDir.getAbsolutePath() + "]");
            this.unzip(this.jobArchive.getData(), this.workingDir);
            this.log.debug("Job archive has been extracted [path=" + this.workingDir.getAbsolutePath() + "]");
            return this.prepareNativeProcessRunner();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void doAfter() {
        if (this.workingDir != null) {
            this.delete(this.workingDir);
            this.log.debug("Directory has been deleted [path=" + this.workingDir.getAbsolutePath() + "]");
        }
    }

    private NativeProcessRunner prepareNativeProcessRunner() {
        if (this.workingDir == null) {
            throw new IllegalStateException("Working directory is not created");
        }
        ProcessBuilder procBuilder = new TensorFlowProcessBuilderSupplier(false, null, new String[0]).get();
        procBuilder.directory(this.workingDir);
        procBuilder.command(this.jobArchive.getCommands());
        Map<String, String> env = procBuilder.environment();
        env.put("PYTHONPATH", this.workingDir.getAbsolutePath());
        env.put("TF_CLUSTER", this.formatTfClusterVar());
        env.put("TF_WORKERS", this.formatTfWorkersVar());
        env.put("TF_CHIEF_SERVER", this.formatTfChiefServerVar());
        return new NativeProcessRunner(procBuilder, null, this.out, this.err);
    }

    private String formatTfClusterVar() {
        return this.clusterSpec.format(Ignition.ignite());
    }

    private String formatTfWorkersVar() {
        StringJoiner joiner = new StringJoiner(", ");
        int cnt = this.clusterSpec.getJobs().get("worker").size();
        for (int i = 0; i < cnt; ++i) {
            joiner.add("\"/job:worker/task:" + i + "\"");
        }
        return "[" + joiner + "]";
    }

    private String formatTfChiefServerVar() {
        List<TensorFlowServerAddressSpec> tasks = this.clusterSpec.getJobs().get("chief");
        if (tasks == null || tasks.size() != 1) {
            throw new IllegalStateException("TensorFlow cluster specification should contain exactly one chief task");
        }
        TensorFlowServerAddressSpec addrSpec = tasks.iterator().next();
        return "grpc://" + addrSpec.format(Ignition.ignite());
    }

    private void delete(File file) {
        if (file.isDirectory()) {
            String[] files = file.list();
            if (files != null && files.length != 0) {
                for (String fileToBeDeleted : files) {
                    this.delete(new File(file, fileToBeDeleted));
                }
            }
            if (!file.delete()) {
                throw new IllegalStateException("Can't delete directory [path=" + file.getAbsolutePath() + "]");
            }
        } else if (!file.delete()) {
            throw new IllegalStateException("Can't delete file [path=" + file.getAbsolutePath() + "]");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void unzip(byte[] data, File extractTo) {
        try (ZipInputStream zipStream = new ZipInputStream(new ByteArrayInputStream(data));){
            ZipEntry entry;
            while ((entry = zipStream.getNextEntry()) != null) {
                BufferedOutputStream out;
                block26: {
                    boolean created;
                    File file = new File(extractTo, entry.getName());
                    if (entry.isDirectory() && !file.exists()) {
                        created = file.mkdirs();
                        if (created) continue;
                        throw new IllegalStateException("Can't create directory [path=" + file.getAbsolutePath() + "]");
                    }
                    if (!file.getParentFile().exists() && !(created = file.getParentFile().mkdirs())) {
                        throw new IllegalStateException("Can't create directory [path=" + file.getParentFile().getAbsolutePath() + "]");
                    }
                    out = new BufferedOutputStream(new FileOutputStream(file));
                    Throwable throwable = null;
                    try {
                        IOUtils.copy((InputStream)zipStream, (OutputStream)out);
                        if (out == null) continue;
                        if (throwable == null) break block26;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (out == null) throw throwable3;
                            if (throwable != null) {
                                try {
                                    out.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                            out.close();
                            throw throwable3;
                        }
                    }
                    try {
                        out.close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                out.close();
            }
            return;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

