/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.tensorflow.cluster.tfrunning;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.Ignite;
import org.apache.ignite.Ignition;
import org.apache.ignite.tensorflow.cluster.spec.TensorFlowClusterSpec;
import org.apache.ignite.tensorflow.cluster.spec.TensorFlowServerAddressSpec;
import org.apache.ignite.tensorflow.cluster.tfrunning.TensorFlowServer;
import org.apache.ignite.tensorflow.cluster.tfrunning.TensorFlowServerScriptFormatter;
import org.apache.ignite.tensorflow.cluster.util.TensorFlowProcessBuilderSupplier;
import org.apache.ignite.tensorflow.core.ProcessManager;
import org.apache.ignite.tensorflow.core.ProcessManagerWrapper;
import org.apache.ignite.tensorflow.core.nativerunning.NativeProcess;
import org.apache.ignite.tensorflow.core.nativerunning.NativeProcessManager;

public class TensorFlowServerManager
extends ProcessManagerWrapper<NativeProcess, TensorFlowServer> {
    private static final TensorFlowServerScriptFormatter scriptFormatter = new TensorFlowServerScriptFormatter();

    public TensorFlowServerManager(Ignite ignite) {
        this(new NativeProcessManager(ignite));
    }

    public TensorFlowServerManager(ProcessManager<NativeProcess> delegate) {
        super(delegate);
    }

    @Override
    protected NativeProcess transformSpecification(TensorFlowServer spec) {
        return new NativeProcess(new TensorFlowProcessBuilderSupplier(true, true, "job:" + spec.getJobName(), "task:" + spec.getTaskIdx()), scriptFormatter.format(spec, true, Ignition.ignite()), this.getNode(spec));
    }

    private UUID getNode(TensorFlowServer spec) {
        TensorFlowClusterSpec clusterSpec = spec.getClusterSpec();
        Map<String, List<TensorFlowServerAddressSpec>> jobs = clusterSpec.getJobs();
        List<TensorFlowServerAddressSpec> tasks = jobs.get(spec.getJobName());
        TensorFlowServerAddressSpec addr = tasks.get(spec.getTaskIdx());
        return addr.getNodeId();
    }
}

