/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.tensorflow.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.tensorflow.core.ProcessManager;
import org.apache.ignite.tensorflow.core.longrunning.task.util.LongRunningProcessStatus;

public abstract class ProcessManagerWrapper<T, R>
implements ProcessManager<R> {
    private final ProcessManager<T> delegate;

    public ProcessManagerWrapper(ProcessManager<T> delegate) {
        assert (delegate != null) : "Delegate should not be null";
        this.delegate = delegate;
    }

    protected abstract T transformSpecification(R var1);

    @Override
    public Map<UUID, List<UUID>> start(List<R> specifications) {
        ArrayList<T> transformedSpecifications = new ArrayList<T>();
        for (R spec : specifications) {
            transformedSpecifications.add(this.transformSpecification(spec));
        }
        return this.delegate.start(transformedSpecifications);
    }

    @Override
    public Map<UUID, List<LongRunningProcessStatus>> ping(Map<UUID, List<UUID>> procIds) {
        return this.delegate.ping(procIds);
    }

    @Override
    public Map<UUID, List<LongRunningProcessStatus>> stop(Map<UUID, List<UUID>> procIds, boolean clear) {
        return this.delegate.stop(procIds, clear);
    }

    @Override
    public Map<UUID, List<LongRunningProcessStatus>> clear(Map<UUID, List<UUID>> procIds) {
        return this.delegate.clear(procIds);
    }
}

