/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.tensorflow.cluster.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.UUID;
import org.apache.ignite.Ignite;
import org.apache.ignite.cache.affinity.Affinity;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.tensorflow.cluster.spec.TensorFlowClusterSpec;
import org.apache.ignite.tensorflow.cluster.spec.TensorFlowServerAddressSpec;
import org.apache.ignite.tensorflow.cluster.util.ClusterPortManager;

public class TensorFlowClusterResolver {
    public static final String WORKER_JOB_NAME = "worker";
    public static final String CHIEF_JOB_NAME = "chief";
    private final Ignite ignite;
    private final ClusterPortManager portMgr;

    public TensorFlowClusterResolver(Ignite ignite, String portPoolName, int portFrom, int portCnt) {
        assert (ignite != null) : "Ignite instance should not be null";
        assert (portPoolName != null) : "Port pool name should not be null";
        assert (portFrom >= 0) : "Port count should not be negative";
        assert (portCnt >= 0 && portCnt + portFrom <= 65535) : "Port range should be between 0 and 65535";
        this.ignite = ignite;
        this.portMgr = new ClusterPortManager(ignite, portPoolName, portFrom, portCnt);
    }

    public TensorFlowClusterSpec resolveAndAcquirePorts(String upstreamCacheName) {
        TensorFlowClusterSpec spec = new TensorFlowClusterSpec();
        this.resolveAndAcquirePortsForWorkers(spec, upstreamCacheName);
        this.resolveAndAcquirePortsForChief(spec);
        return spec;
    }

    public void releasePorts(TensorFlowClusterSpec spec) {
        for (String jobName : spec.getJobs().keySet()) {
            for (TensorFlowServerAddressSpec address : spec.getJobs().get(jobName)) {
                this.portMgr.releasePort(address.getNodeId(), address.getPort());
            }
        }
    }

    public void destroy() {
        this.portMgr.destroy();
    }

    private void resolveAndAcquirePortsForWorkers(TensorFlowClusterSpec spec, String upstreamCacheName) {
        Affinity affinity = this.ignite.affinity(upstreamCacheName);
        int parts = affinity.partitions();
        HashSet<UUID> distinctNodeIds = new HashSet<UUID>();
        for (int part = 0; part < parts; ++part) {
            ClusterNode node = affinity.mapPartitionToNode(part);
            UUID nodeId = node.id();
            distinctNodeIds.add(nodeId);
        }
        ArrayList nodeIds = new ArrayList(distinctNodeIds);
        Collections.sort(nodeIds);
        for (UUID nodeId : nodeIds) {
            int port = this.portMgr.acquirePort(nodeId);
            spec.addTask(WORKER_JOB_NAME, nodeId, port);
        }
    }

    private void resolveAndAcquirePortsForChief(TensorFlowClusterSpec spec) {
        ClusterNode chiefNode = this.ignite.cluster().localNode();
        UUID chiefNodeId = chiefNode.id();
        int chiefPort = this.portMgr.acquirePort(chiefNodeId);
        spec.addTask(CHIEF_JOB_NAME, chiefNodeId, chiefPort);
    }
}

