/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.tensorflow.cluster;

import java.util.HashSet;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.tensorflow.cluster.TensorFlowCluster;
import org.apache.ignite.tensorflow.util.SerializableConsumer;

public class TensorFlowClusterGateway
implements IgniteBiPredicate<UUID, Optional<TensorFlowCluster>>,
AutoCloseable {
    private static final long serialVersionUID = -540323262800791340L;
    private final SerializableConsumer<TensorFlowClusterGateway> unsubscribeCb;
    private final HashSet<Consumer<Optional<TensorFlowCluster>>> subscribers = new HashSet();
    private Optional<TensorFlowCluster> last;

    public TensorFlowClusterGateway(SerializableConsumer<TensorFlowClusterGateway> unsubscribeCb) {
        this.unsubscribeCb = unsubscribeCb;
    }

    public synchronized void subscribe(Consumer<Optional<TensorFlowCluster>> subscriber) {
        this.subscribers.add(subscriber);
        if (this.last != null) {
            subscriber.accept(this.last);
        }
    }

    public synchronized void unsubscribe(Consumer<Optional<TensorFlowCluster>> subscriber) {
        this.subscribers.remove(subscriber);
    }

    public synchronized boolean apply(UUID uuid, Optional<TensorFlowCluster> cluster) {
        for (Consumer<Optional<TensorFlowCluster>> subscriber : this.subscribers) {
            subscriber.accept(cluster);
        }
        this.last = cluster;
        return true;
    }

    @Override
    public void close() {
        this.subscribers.clear();
        this.unsubscribeCb.accept(this);
    }
}

