/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed.raft.handlers;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.partition.replicator.network.command.BuildIndexCommand;
import org.apache.ignite.internal.partition.replicator.network.command.BuildIndexCommandV3;
import org.apache.ignite.internal.partition.replicator.raft.CommandResult;
import org.apache.ignite.internal.partition.replicator.raft.handlers.AbstractCommandHandler;
import org.apache.ignite.internal.partition.replicator.raft.snapshot.PartitionDataStorage;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.schema.BinaryRowUpgrader;
import org.apache.ignite.internal.schema.SchemaDescriptor;
import org.apache.ignite.internal.schema.SchemaRegistry;
import org.apache.ignite.internal.storage.BinaryRowAndRowId;
import org.apache.ignite.internal.storage.RowId;
import org.apache.ignite.internal.table.distributed.StorageUpdateHandler;
import org.apache.ignite.internal.table.distributed.index.IndexMeta;
import org.apache.ignite.internal.table.distributed.index.IndexMetaStorage;
import org.apache.ignite.internal.table.distributed.index.MetaIndexStatus;
import org.apache.ignite.internal.table.distributed.index.MetaIndexStatusChange;
import org.apache.ignite.internal.table.distributed.raft.handlers.BuildIndexRowVersionChooser;
import org.apache.ignite.internal.util.CollectionUtils;
import org.jetbrains.annotations.Nullable;

public class BuildIndexCommandHandler
extends AbstractCommandHandler<BuildIndexCommand> {
    private static final IgniteLogger LOG = Loggers.forClass(BuildIndexCommandHandler.class);
    private final PartitionDataStorage storage;
    private final IndexMetaStorage indexMetaStorage;
    private final StorageUpdateHandler storageUpdateHandler;
    private final SchemaRegistry schemaRegistry;

    public BuildIndexCommandHandler(PartitionDataStorage storage, IndexMetaStorage indexMetaStorage, StorageUpdateHandler storageUpdateHandler, SchemaRegistry schemaRegistry) {
        this.storage = storage;
        this.indexMetaStorage = indexMetaStorage;
        this.storageUpdateHandler = storageUpdateHandler;
        this.schemaRegistry = schemaRegistry;
    }

    protected CommandResult handleInternally(BuildIndexCommand command, long commandIndex, long commandTerm, @Nullable HybridTimestamp safeTimestamp) throws IgniteInternalException {
        if (commandIndex <= this.storage.lastAppliedIndex()) {
            return CommandResult.EMPTY_NOT_APPLIED_RESULT;
        }
        IndexMeta indexMeta = this.indexMetaStorage.indexMeta(command.indexId());
        if (indexMeta == null || indexMeta.isDropped()) {
            this.storage.runConsistently(locker -> {
                this.storage.lastApplied(commandIndex, commandTerm);
                return null;
            });
            return CommandResult.EMPTY_APPLIED_RESULT;
        }
        Set abortedTransactionIds = command instanceof BuildIndexCommandV3 ? ((BuildIndexCommandV3)command).abortedTransactionIds() : Set.of();
        BuildIndexRowVersionChooser rowVersionChooser = this.createBuildIndexRowVersionChooser(indexMeta, abortedTransactionIds);
        BinaryRowUpgrader binaryRowUpgrader = this.createBinaryRowUpgrader(indexMeta);
        List rowIds = command.rowIds().stream().sorted().map(this::toRowId).collect(Collectors.toList());
        @Nullable RowId lastRowId = (RowId)CollectionUtils.last(rowIds);
        AtomicInteger rowIdsIterationIndex = new AtomicInteger(0);
        boolean finished = false;
        while (!finished) {
            finished = (Boolean)this.storage.runConsistently(locker -> {
                if (rowIds.isEmpty()) {
                    this.storageUpdateHandler.getIndexUpdateHandler().buildIndex(command.indexId(), Stream.of(new BinaryRowAndRowId[0]), null);
                } else {
                    int index = rowIdsIterationIndex.get();
                    while (index < rowIds.size()) {
                        RowId rowId = (RowId)rowIds.get(index);
                        locker.lock(rowId);
                        Stream<BinaryRowAndRowId> rowVersions = rowVersionChooser.chooseForBuildIndex(rowId).stream().map(row -> BuildIndexCommandHandler.upgradeBinaryRow(binaryRowUpgrader, row));
                        RowId nextRowIdToBuild = null;
                        if (index != rowIds.size() - 1) {
                            nextRowIdToBuild = (RowId)rowIds.get(index + 1);
                        } else if (!command.finish()) {
                            nextRowIdToBuild = Objects.requireNonNull(lastRowId).increment();
                        }
                        this.storageUpdateHandler.getIndexUpdateHandler().buildIndex(command.indexId(), rowVersions, nextRowIdToBuild);
                        index = rowIdsIterationIndex.incrementAndGet();
                        if (!locker.shouldRelease() || index >= rowIds.size()) continue;
                        return false;
                    }
                }
                this.storage.lastApplied(commandIndex, commandTerm);
                return true;
            });
        }
        if (command.finish()) {
            LOG.info("Finish building the index [tableId={}, partitionId={}, indexId={}].", new Object[]{this.storage.tableId(), this.storage.partitionId(), command.indexId()});
        }
        return CommandResult.EMPTY_APPLIED_RESULT;
    }

    private BuildIndexRowVersionChooser createBuildIndexRowVersionChooser(IndexMeta indexMeta, Set<UUID> abortedTransactionIds) {
        MetaIndexStatusChange registeredChangeInfo = indexMeta.statusChange(MetaIndexStatus.REGISTERED);
        MetaIndexStatusChange buildingChangeInfo = indexMeta.statusChange(MetaIndexStatus.BUILDING);
        return new BuildIndexRowVersionChooser(this.storage, registeredChangeInfo.activationTimestamp(), buildingChangeInfo.activationTimestamp(), abortedTransactionIds);
    }

    private BinaryRowUpgrader createBinaryRowUpgrader(IndexMeta indexMeta) {
        SchemaDescriptor schema = this.schemaRegistry.schema(indexMeta.tableVersion());
        return new BinaryRowUpgrader(this.schemaRegistry, schema);
    }

    private static BinaryRowAndRowId upgradeBinaryRow(BinaryRowUpgrader upgrader, BinaryRowAndRowId source) {
        BinaryRow sourceBinaryRow = source.binaryRow();
        assert (sourceBinaryRow != null) : "rowId=" + source.rowId();
        BinaryRow upgradedBinaryRow = upgrader.upgrade(sourceBinaryRow);
        return upgradedBinaryRow == sourceBinaryRow ? source : new BinaryRowAndRowId(upgradedBinaryRow, source.rowId());
    }

    private RowId toRowId(UUID rowUuid) {
        return new RowId(this.storageUpdateHandler.partitionId(), rowUuid);
    }
}

