/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed.gc;

import java.util.List;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.partition.replicator.raft.snapshot.PartitionDataStorage;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.storage.MvPartitionStorage;
import org.apache.ignite.internal.storage.ReadResult;
import org.apache.ignite.internal.storage.RowId;
import org.apache.ignite.internal.storage.gc.GcEntry;
import org.apache.ignite.internal.table.distributed.gc.IntHolder;
import org.apache.ignite.internal.table.distributed.index.IndexUpdateHandler;
import org.apache.ignite.internal.util.Cursor;
import org.apache.ignite.internal.util.PendingComparableValuesTracker;

public class GcUpdateHandler {
    private final PartitionDataStorage storage;
    private final IndexUpdateHandler indexUpdateHandler;
    private final PendingComparableValuesTracker<HybridTimestamp, Void> safeTimeTracker;

    public GcUpdateHandler(PartitionDataStorage storage, PendingComparableValuesTracker<HybridTimestamp, Void> safeTimeTracker, IndexUpdateHandler indexUpdateHandler) {
        this.storage = storage;
        this.indexUpdateHandler = indexUpdateHandler;
        this.safeTimeTracker = safeTimeTracker;
    }

    public PendingComparableValuesTracker<HybridTimestamp, Void> getSafeTimeTracker() {
        return this.safeTimeTracker;
    }

    public boolean vacuumBatch(HybridTimestamp lowWatermark, int count) {
        if (count <= 0) {
            return true;
        }
        this.storage.runConsistently(locker -> {
            this.storage.trimUpdateLog(lowWatermark, count);
            return null;
        });
        IntHolder countHolder = new IntHolder(count);
        block6: while (countHolder.get() > 0) {
            VacuumResult vacuumResult = this.internalVacuumBatch(lowWatermark, countHolder);
            switch (vacuumResult) {
                case NO_GARBAGE_LEFT: {
                    return false;
                }
                case SUCCESS: {
                    return true;
                }
                case FAILED_ACQUIRE_LOCK: 
                case REMOVED_BY_ANOTHER_THREAD: {
                    continue block6;
                }
                case SHOULD_RELEASE: {
                    return true;
                }
            }
            throw new IllegalStateException(vacuumResult.toString());
        }
        return true;
    }

    private VacuumResult internalVacuumBatch(HybridTimestamp lowWatermark, IntHolder countHolder) {
        int count = countHolder.get();
        List peekEntries = this.storage.peek(lowWatermark, count);
        if (peekEntries.isEmpty()) {
            return VacuumResult.NO_GARBAGE_LEFT;
        }
        return (VacuumResult)((Object)this.storage.runConsistently(locker -> {
            boolean someRowRemovedByAnotherThread = false;
            for (int i = 0; i < peekEntries.size(); ++i) {
                if (locker.shouldRelease()) {
                    return VacuumResult.SHOULD_RELEASE;
                }
                VacuumResult vacuumResult = this.internalVacuum((GcEntry)peekEntries.get(i), locker, i > 0);
                if (vacuumResult == VacuumResult.REMOVED_BY_ANOTHER_THREAD) {
                    someRowRemovedByAnotherThread = true;
                    continue;
                }
                if (vacuumResult != VacuumResult.SUCCESS) {
                    return vacuumResult;
                }
                countHolder.getAndDecrement();
            }
            if (someRowRemovedByAnotherThread) {
                return VacuumResult.REMOVED_BY_ANOTHER_THREAD;
            }
            return countHolder.get() == 0 ? VacuumResult.SUCCESS : VacuumResult.NO_GARBAGE_LEFT;
        }));
    }

    private VacuumResult internalVacuum(GcEntry gcEntry, MvPartitionStorage.Locker locker, boolean useTryLock) {
        BinaryRow binaryRow;
        RowId rowId = gcEntry.getRowId();
        if (useTryLock) {
            if (!locker.tryLock(rowId)) {
                return VacuumResult.FAILED_ACQUIRE_LOCK;
            }
        } else {
            locker.lock(rowId);
        }
        if ((binaryRow = this.storage.vacuum(gcEntry)) == null) {
            return VacuumResult.REMOVED_BY_ANOTHER_THREAD;
        }
        try (Cursor cursor = this.storage.scanVersions(rowId);){
            this.indexUpdateHandler.tryRemoveFromIndexes(binaryRow, rowId, (Cursor<ReadResult>)cursor, null);
        }
        return VacuumResult.SUCCESS;
    }

    private static enum VacuumResult {
        SUCCESS,
        NO_GARBAGE_LEFT,
        FAILED_ACQUIRE_LOCK,
        SHOULD_RELEASE,
        REMOVED_BY_ANOTHER_THREAD;

    }
}

