/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed.expiration;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.hlc.HybridTimestampTracker;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.network.InternalClusterNode;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.schema.BinaryRowEx;
import org.apache.ignite.internal.schema.SchemaDescriptor;
import org.apache.ignite.internal.table.InternalTable;
import org.apache.ignite.internal.table.distributed.expiration.ExpiredRowsScanner;
import org.apache.ignite.internal.table.distributed.expiration.PartitionCleanerTask;
import org.apache.ignite.internal.table.distributed.expiration.metrics.ExpirationMetricSource;
import org.apache.ignite.internal.tx.InternalTransaction;
import org.apache.ignite.internal.tx.InternalTxOptions;
import org.apache.ignite.internal.tx.TxManager;
import org.apache.ignite.internal.tx.TxPriority;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.sql.ColumnType;
import org.gridgain.internal.license.LicenseFeature;
import org.gridgain.internal.license.LicenseFeatureChecker;
import org.gridgain.internal.license.MissingRequiredFeaturesException;

class PartitionCleanerHelper {
    private static final IgniteLogger LOG = Loggers.forClass(PartitionCleanerTask.class);
    private final TxManager txManager;
    private final HybridTimestampTracker observableTimestampTracker;
    private final int tableId;
    private final int partitionId;
    private final int batchSize;
    private final InternalClusterNode localMember;
    private final LicenseFeatureChecker licenseFeatureChecker;
    private final ExpirationMetricSource metrics;
    private final ExpiredRowsScanner scanner;

    PartitionCleanerHelper(int batchSize, int tableId, int partitionId, TxManager txManager, HybridTimestampTracker observableTimestampTracker, InternalClusterNode localMember, LicenseFeatureChecker licenseFeatureChecker, ExpirationMetricSource metrics, ExpiredRowsScanner scanner) {
        this.txManager = txManager;
        this.observableTimestampTracker = observableTimestampTracker;
        this.tableId = tableId;
        this.partitionId = partitionId;
        this.batchSize = batchSize;
        this.localMember = localMember;
        this.licenseFeatureChecker = licenseFeatureChecker;
        this.metrics = metrics;
        this.scanner = scanner;
    }

    public CompletableFuture<Boolean> deleteExpiredRows(SchemaDescriptor schemaDescriptor, InternalTable internalTable, HybridTimestamp hybridTimestamp, int expireColIndexId, ColumnType expireColType) {
        return this.inTransaction(tx -> this.invokeCleanOperation((InternalTransaction)tx, schemaDescriptor, internalTable, hybridTimestamp, expireColIndexId, expireColType, LicenseFeature.EXPIRY, this::deleteRows));
    }

    public CompletableFuture<Boolean> archiveExpiredRows(SchemaDescriptor schemaDescriptor, InternalTable internalTable, HybridTimestamp hybridTimestamp, int archiveColIndexId, ColumnType archiveColType) {
        return this.inTransaction(tx -> this.invokeCleanOperation((InternalTransaction)tx, schemaDescriptor, internalTable, hybridTimestamp, archiveColIndexId, archiveColType, LicenseFeature.EXTENDED_SECONDARY_STORAGE, this::archiveRows));
    }

    private CompletableFuture<Boolean> inTransaction(Function<InternalTransaction, CompletableFuture<Boolean>> cleanupOperation) {
        InternalTransaction transaction = this.txManager.beginExplicitRo(this.observableTimestampTracker, InternalTxOptions.builder().priority(TxPriority.LOW).build());
        CompletableFuture<Boolean> cleanFuture = cleanupOperation.apply(transaction);
        return ((CompletableFuture)((CompletableFuture)cleanFuture.thenCompose(deleted -> transaction.commitAsync().thenApply(v -> deleted))).handle((deleted, e) -> {
            if (e == null) {
                return CompletableFuture.completedFuture(deleted);
            }
            return transaction.rollbackAsync().thenCompose(v -> CompletableFuture.failedFuture(e));
        })).thenCompose(Function.identity());
    }

    private CompletableFuture<Boolean> invokeCleanOperation(InternalTransaction transaction, SchemaDescriptor schemaDescriptor, InternalTable internalTable, HybridTimestamp hybridTimestamp, int scannedColIndexId, ColumnType scannedColType, LicenseFeature requiredLicenseFeature, PartitionCleanOperation cleanOperation) {
        return this.scanRowsToCleanup(transaction, schemaDescriptor, internalTable, hybridTimestamp, scannedColIndexId, scannedColType).thenCompose(rows -> {
            if (rows.isEmpty()) {
                return CompletableFuture.completedFuture(false);
            }
            if (!this.checkLicenseFeature(requiredLicenseFeature)) {
                return CompletableFuture.completedFuture(false);
            }
            return cleanOperation.cleanupRows(internalTable, this.partitionId, (List<BinaryRowEx>)rows).thenApply(List::isEmpty);
        });
    }

    private CompletableFuture<List<BinaryRowEx>> scanRowsToCleanup(InternalTransaction transaction, SchemaDescriptor schemaDescriptor, InternalTable internalTable, HybridTimestamp hybridTimestamp, int scannedColIndexId, ColumnType scannedColType) {
        return this.scanner.scan(transaction, schemaDescriptor, internalTable, hybridTimestamp, scannedColIndexId, scannedColType, this.batchSize, this.partitionId, this.localMember);
    }

    private boolean checkLicenseFeature(LicenseFeature licenseFeature) {
        try {
            this.licenseFeatureChecker.checkFeature(licenseFeature);
            return true;
        }
        catch (MissingRequiredFeaturesException e) {
            LOG.warn("Rows requiring cleanup found, but {} feature is not allowed. Rows will not be deleted.", new Object[]{licenseFeature});
            return false;
        }
    }

    private CompletableFuture<List<BinaryRow>> deleteRows(InternalTable internalTable, int partitionId, List<BinaryRowEx> rows) {
        LOG.debug("Found {} expired rows to cleanup. partition {}", new Object[]{rows.size(), partitionId});
        InternalTransaction tx = internalTable.cache() ? this.txManager.beginExternal(this.observableTimestampTracker, false, TxPriority.LOW) : this.txManager.beginExplicitRw(this.observableTimestampTracker, InternalTxOptions.builder().priority(TxPriority.LOW).build());
        return ((CompletableFuture)((CompletableFuture)internalTable.deleteAllExact(rows, tx).thenCompose(result -> tx.commitAsync().thenApply(ignored -> result))).handle((result, throwable) -> {
            if (throwable == null) {
                this.metrics.addDeletedExpiredRowsCnt(internalTable.name().toCanonicalForm(), this.tableId, partitionId, rows.size() - result.size());
                return CompletableFuture.completedFuture(result);
            }
            return tx.rollbackAsync().thenCompose(ignored -> CompletableFuture.failedFuture(ExceptionUtils.unwrapCause((Throwable)throwable)));
        })).thenCompose(future -> future);
    }

    private CompletableFuture<List<BinaryRow>> archiveRows(InternalTable internalTable, int partitionId, List<BinaryRowEx> rows) {
        LOG.debug("Found {} rows to archive. partition {}", new Object[]{rows.size(), partitionId});
        InternalTransaction tx = internalTable.cache() ? this.txManager.beginExternal(this.observableTimestampTracker, false, TxPriority.LOW) : this.txManager.beginExplicitRw(this.observableTimestampTracker, InternalTxOptions.builder().priority(TxPriority.LOW).build());
        return ((CompletableFuture)((CompletableFuture)internalTable.archiveAllExact(rows, tx).thenCompose(result -> tx.commitAsync().thenApply(ignored -> result))).handle((result, throwable) -> {
            if (throwable == null) {
                return CompletableFuture.completedFuture(result);
            }
            return tx.rollbackAsync().thenCompose(ignored -> CompletableFuture.failedFuture(ExceptionUtils.unwrapCause((Throwable)throwable)));
        })).thenCompose(future -> future);
    }

    @FunctionalInterface
    private static interface PartitionCleanOperation {
        public CompletableFuture<List<BinaryRow>> cleanupRows(InternalTable var1, int var2, List<BinaryRowEx> var3);
    }
}

