/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed.disaster;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.internal.table.distributed.disaster.DisasterRecoveryRequestsSerialization;
import org.apache.ignite.internal.table.distributed.disaster.GroupUpdateRequest;
import org.apache.ignite.internal.util.io.IgniteDataInput;
import org.apache.ignite.internal.util.io.IgniteDataOutput;
import org.apache.ignite.internal.versioned.VersionedSerializer;

class GroupUpdateRequestSerializer
extends VersionedSerializer<GroupUpdateRequest> {
    static final GroupUpdateRequestSerializer INSTANCE = new GroupUpdateRequestSerializer();

    GroupUpdateRequestSerializer() {
    }

    protected byte getProtocolVersion() {
        return 2;
    }

    protected void writeExternalData(GroupUpdateRequest request, IgniteDataOutput out) throws IOException {
        out.writeUuid(request.operationId());
        out.writeVarInt((long)request.catalogVersion());
        out.writeVarInt((long)request.zoneId());
        DisasterRecoveryRequestsSerialization.writeVarIntMap(request.partitionIds(), out);
        out.writeBoolean(request.manualUpdate());
        out.writeBoolean(true);
    }

    protected GroupUpdateRequest readExternalData(byte protoVer, IgniteDataInput in) throws IOException {
        boolean usesZonePartitionIds;
        UUID operationId = in.readUuid();
        int catalogVersion = in.readVarIntAsInt();
        int zoneId = in.readVarIntAsInt();
        Map<Integer, Set<Integer>> partitionIds = DisasterRecoveryRequestsSerialization.readVarIntMap(in);
        boolean manualUpdate = in.readBoolean();
        boolean bl = usesZonePartitionIds = protoVer >= 2 && in.readBoolean();
        if (!usesZonePartitionIds) {
            throw new IllegalArgumentException("Non-colocated GroupUpdateRequest is not supported [ver=" + protoVer + "]");
        }
        return GroupUpdateRequest.create(operationId, catalogVersion, zoneId, partitionIds, manualUpdate);
    }
}

