/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed;

import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class TableStatsStalenessConfiguration {
    private final double staleRowsFraction;
    private final long minStaleRowsCount;

    public TableStatsStalenessConfiguration(double staleRowsFraction, long minStaleRowsCount) {
        if (staleRowsFraction < 0.0 || staleRowsFraction > 1.0) {
            throw new IllegalArgumentException("staleRowsFraction must be in [0, 1] range");
        }
        if (minStaleRowsCount < 0L) {
            throw new IllegalArgumentException("minStaleRowsCount must be non-negative");
        }
        this.staleRowsFraction = staleRowsFraction;
        this.minStaleRowsCount = minStaleRowsCount;
    }

    public double staleRowsFraction() {
        return this.staleRowsFraction;
    }

    public long minStaleRowsCount() {
        return this.minStaleRowsCount;
    }

    public TableStatsStalenessConfiguration update(@Nullable Double staleRowsFraction, @Nullable Long minStaleRowsCount) {
        if (staleRowsFraction == null && minStaleRowsCount == null) {
            return this;
        }
        return new TableStatsStalenessConfiguration(Objects.requireNonNullElse(staleRowsFraction, this.staleRowsFraction), Objects.requireNonNullElse(minStaleRowsCount, this.minStaleRowsCount));
    }
}

