/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed;

import java.util.concurrent.Executor;
import java.util.function.IntFunction;
import org.apache.ignite.internal.network.InternalClusterNode;
import org.apache.ignite.internal.network.MessagingService;
import org.apache.ignite.internal.network.NetworkMessage;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessageGroup;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite.internal.partition.replicator.network.message.DataPresence;
import org.apache.ignite.internal.partition.replicator.network.message.HasDataRequest;
import org.apache.ignite.internal.storage.MvPartitionStorage;
import org.apache.ignite.internal.storage.RowId;
import org.apache.ignite.internal.storage.StorageClosedException;
import org.apache.ignite.internal.storage.StorageRebalanceException;
import org.apache.ignite.internal.storage.engine.MvTableStorage;
import org.apache.ignite.internal.table.TableViewInternal;

class PartitionReplicatorNodeRecovery {
    private static final PartitionReplicationMessagesFactory TABLE_MESSAGES_FACTORY = new PartitionReplicationMessagesFactory();
    private final MessagingService messagingService;
    private final Executor storageAccessExecutor;
    private final IntFunction<TableViewInternal> tableById;

    PartitionReplicatorNodeRecovery(MessagingService messagingService, Executor storageAccessExecutor, IntFunction<TableViewInternal> tableById) {
        this.messagingService = messagingService;
        this.storageAccessExecutor = storageAccessExecutor;
        this.tableById = tableById;
    }

    void start() {
        this.addMessageHandler();
    }

    private void addMessageHandler() {
        this.messagingService.addMessageHandler(PartitionReplicationMessageGroup.class, (message, sender, correlationId) -> {
            if (message instanceof HasDataRequest) {
                assert (correlationId != null);
                HasDataRequest msg = (HasDataRequest)message;
                this.storageAccessExecutor.execute(() -> this.handleHasDataRequest(msg, sender, correlationId));
            }
        });
    }

    private void handleHasDataRequest(HasDataRequest msg, InternalClusterNode sender, Long correlationId) {
        int tableId = msg.tableId();
        int partitionId = msg.partitionId();
        DataPresence dataPresence = DataPresence.UNKNOWN;
        TableViewInternal table = this.tableById.apply(tableId);
        if (table != null) {
            MvTableStorage storage = table.internalTable().storage();
            try {
                MvPartitionStorage mvPartition = storage.getMvPartition(partitionId);
                if (mvPartition != null) {
                    dataPresence = mvPartition.closestRowId(RowId.lowestRowId((int)partitionId)) != null ? DataPresence.HAS_DATA : DataPresence.EMPTY;
                }
            }
            catch (StorageClosedException | StorageRebalanceException throwable) {
                // empty catch block
            }
        }
        this.messagingService.respond(sender, (NetworkMessage)TABLE_MESSAGES_FACTORY.hasDataResponse().presenceString(dataPresence.name()).build(), correlationId.longValue());
    }
}

